/*
 * Decompiled with CFR 0.152.
 */
package com.gradleware.tooling.toolingclient.internal.deduplication;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.gradleware.tooling.toolingclient.internal.deduplication.HierarchicalElementDeduplicator;
import com.gradleware.tooling.toolingclient.internal.deduplication.NameDeduplicationAdapter;
import com.gradleware.tooling.toolingclient.internal.deduplication.RedirectedProjectLookup;
import com.gradleware.tooling.toolingclient.internal.deduplication.RedirectionAwareEclipseProject;
import com.gradleware.tooling.toolingclient.internal.deduplication.RenamedEclipseProject;
import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.impldep.com.google.common.collect.Sets;
import org.gradle.tooling.model.eclipse.EclipseProject;

class EclipseProjectDeduplicator {
    EclipseProjectDeduplicator() {
    }

    public Set<EclipseProject> deduplicate(Set<EclipseProject> eclipseProjects) {
        RenamedEclipseProjectTracker renamedProjectTracker = new RenamedEclipseProjectTracker(eclipseProjects);
        this.deduplicate(eclipseProjects, renamedProjectTracker);
        return renamedProjectTracker.getRenamedProjects();
    }

    private void deduplicate(Set<EclipseProject> eclipseProjects, RenamedEclipseProjectTracker renamedElementTracker) {
        HashSet rootProjectNames = Sets.newHashSet();
        for (EclipseProject eclipseProject : eclipseProjects) {
            String name = eclipseProject.getName();
            if (eclipseProject.getParent() != null || rootProjectNames.add(name)) continue;
            throw new IllegalArgumentException(String.format("Duplicate root project name '%s'. Duplicate root project names are currently not supported. This will change in future Gradle versions.", name));
        }
        Map<EclipseProject, String> newNames = new HierarchicalElementDeduplicator<EclipseProject>(new EclipseProjectNameDeduplicationStrategy()).deduplicate(eclipseProjects);
        for (Map.Entry<EclipseProject, String> nameChange : newNames.entrySet()) {
            renamedElementTracker.renameTo(nameChange.getKey(), nameChange.getValue());
        }
    }

    private static class EclipseProjectNameDeduplicationStrategy
    implements NameDeduplicationAdapter<EclipseProject> {
        private EclipseProjectNameDeduplicationStrategy() {
        }

        @Override
        public String getName(EclipseProject element) {
            return element.getName();
        }

        @Override
        public EclipseProject getParent(EclipseProject element) {
            return element.getParent();
        }
    }

    private static class RenamedEclipseProjectTracker
    implements RedirectedProjectLookup {
        private final Map<File, EclipseProject> originalToRenamed = Maps.newHashMap();

        public RenamedEclipseProjectTracker(Set<EclipseProject> originals) {
            for (EclipseProject eclipseProject : originals) {
                this.originalToRenamed.put(eclipseProject.getProjectDirectory(), new RedirectionAwareEclipseProject(eclipseProject, this));
            }
        }

        @Override
        public EclipseProject getRedirectedProject(File projectDirectory) {
            return this.originalToRenamed.get(projectDirectory);
        }

        public void renameTo(EclipseProject original, String newName) {
            File projectDirectory = original.getProjectDirectory();
            if (!this.originalToRenamed.containsKey(projectDirectory)) {
                throw new IllegalArgumentException("Project " + original.getName() + " was not one of the projects to be renamed.");
            }
            this.originalToRenamed.put(projectDirectory, new RenamedEclipseProject(original, newName, this));
        }

        public Set<EclipseProject> getRenamedProjects() {
            return ImmutableSet.copyOf(this.originalToRenamed.values());
        }
    }
}

