/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.preferences.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.eclipse.buildship.core.preferences.PersistentModel;
import org.eclipse.buildship.core.preferences.internal.DefaultModelPersistence;
import org.eclipse.core.resources.IProject;

class DefaultPersistentModel
implements PersistentModel {
    private final DefaultModelPersistence store;
    private final IProject project;
    private final ImmutableMap<String, String> entries;
    private final Map<String, String> added;
    private final Set<String> removed;

    DefaultPersistentModel(DefaultModelPersistence store, IProject project, Map<String, String> entries) {
        this.store = (DefaultModelPersistence)Preconditions.checkNotNull((Object)store);
        this.project = (IProject)Preconditions.checkNotNull((Object)project);
        this.entries = ImmutableMap.copyOf(entries);
        this.added = Maps.newHashMap();
        this.removed = Sets.newHashSet();
    }

    Map<String, String> getAdded() {
        return this.added;
    }

    Set<String> getRemoved() {
        return this.removed;
    }

    IProject getProject() {
        return this.project;
    }

    @Override
    public String getValue(String key, String defaultValue) {
        if (this.added.keySet().contains(key)) {
            return this.added.get(key);
        }
        if (this.removed.contains(key)) {
            return defaultValue;
        }
        String value = (String)this.entries.get((Object)key);
        return value != null ? value : defaultValue;
    }

    @Override
    public void setValue(String key, String value) {
        if (value != null) {
            this.added.put(key, value);
        } else if (this.entries.containsKey((Object)key)) {
            this.removed.add(key);
        }
    }

    @Override
    public void flush() {
        this.store.persistPrefs(this);
        this.added.clear();
        this.removed.clear();
    }
}

