/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.configuration.internal;

import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import java.io.File;
import org.eclipse.buildship.core.configuration.ProjectConfiguration;
import org.eclipse.buildship.core.util.file.RelativePathUtils;
import org.eclipse.buildship.core.util.gradle.GradleDistributionSerializer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

final class ProjectConfigurationProperties {
    private final String projectDir;
    private final String gradleDistribution;

    private ProjectConfigurationProperties(String projectDir, String gradleDistribution) {
        this.projectDir = projectDir;
        this.gradleDistribution = gradleDistribution;
    }

    String getProjectDir() {
        return this.projectDir;
    }

    String getGradleDistribution() {
        return this.gradleDistribution;
    }

    static ProjectConfigurationProperties from(String projectDir, String gradleDistribution) {
        return new ProjectConfigurationProperties(projectDir, gradleDistribution);
    }

    static ProjectConfigurationProperties from(IProject project, ProjectConfiguration projectConfiguration) {
        FixedRequestAttributes requestAttributes = projectConfiguration.toRequestAttributes(ProjectConfiguration.ConversionStrategy.IGNORE_WORKSPACE_SETTINGS);
        String projectDir = ProjectConfigurationProperties.relativePathToRootProject(project, requestAttributes.getProjectDir());
        String gradleDistribution = GradleDistributionSerializer.INSTANCE.serializeToString(requestAttributes.getGradleDistribution());
        return ProjectConfigurationProperties.from(projectDir, gradleDistribution);
    }

    private static String relativePathToRootProject(IProject project, File rootProjectDir) {
        Path rootProjectPath = new Path(rootProjectDir.getPath());
        IPath projectPath = project.getLocation();
        return RelativePathUtils.getRelativePath(projectPath, (IPath)rootProjectPath).toPortableString();
    }

    ProjectConfiguration toProjectConfiguration(IProject project) {
        return ProjectConfiguration.from(ProjectConfigurationProperties.rootProjectFile(project, this.getProjectDir()), GradleDistributionSerializer.INSTANCE.deserializeFromString(this.getGradleDistribution()));
    }

    private static File rootProjectFile(IProject project, String pathToRootProject) {
        Path rootPath = new Path(pathToRootProject);
        if (rootPath.isAbsolute()) {
            return rootPath.toFile();
        }
        return RelativePathUtils.getAbsolutePath(project.getLocation(), (IPath)rootPath).toFile();
    }
}

