/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.wizard.project;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.gradleware.tooling.toolingmodel.OmniEclipseProject;
import com.gradleware.tooling.toolingutils.binding.Property;
import com.gradleware.tooling.toolingutils.binding.ValidationListener;
import com.gradleware.tooling.toolingutils.binding.Validator;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.configuration.BuildConfiguration;
import org.eclipse.buildship.core.projectimport.ProjectImportConfiguration;
import org.eclipse.buildship.core.util.binding.Validators;
import org.eclipse.buildship.core.util.collections.CollectionsUtils;
import org.eclipse.buildship.core.util.file.FileUtils;
import org.eclipse.buildship.core.util.gradle.GradleDistributionValidator;
import org.eclipse.buildship.core.util.gradle.GradleDistributionWrapper;
import org.eclipse.buildship.core.util.progress.AsyncHandler;
import org.eclipse.buildship.core.workspace.GradleBuild;
import org.eclipse.buildship.core.workspace.NewProjectHandler;
import org.eclipse.buildship.ui.util.workbench.WorkbenchUtils;
import org.eclipse.buildship.ui.util.workbench.WorkingSetUtils;
import org.eclipse.buildship.ui.wizard.project.ProjectWizardMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;

public class ProjectImportWizardController {
    private static final String SETTINGS_KEY_PROJECT_DIR = "project_location";
    private static final String SETTINGS_KEY_GRADLE_DISTRIBUTION_TYPE = "gradle_distribution_type";
    private static final String SETTINGS_KEY_GRADLE_DISTRIBUTION_CONFIGURATION = "gradle_distribution_configuration";
    private static final String SETTINGS_KEY_APPLY_WORKING_SETS = "apply_working_sets";
    private static final String SETTINGS_KEY_WORKING_SETS = "working_sets";
    private static final String SETTINGS_KEY_GRADLE_USER_HOME = "gradle_user_home";
    private static final String SETTINGS_KEY_BUILD_SCANS = "build_scans";
    private static final String SETTINGS_KEY_OFFLINE_MODE = "offline_mode";
    private static final String SETTINGS_KEY_AUTO_SYNC = "auto_sync";
    private final ProjectImportConfiguration configuration;

    public ProjectImportWizardController(IWizard projectImportWizard) {
        Validator projectDirValidator = Validators.and((Validator)Validators.requiredDirectoryValidator((String)ProjectWizardMessages.Label_ProjectRootDirectory), (Validator)Validators.nonWorkspaceFolderValidator((String)ProjectWizardMessages.Label_ProjectRootDirectory));
        Validator gradleDistributionValidator = GradleDistributionValidator.gradleDistributionValidator();
        Validator applyWorkingSetsValidator = Validators.nullValidator();
        Validator workingSetsValidator = Validators.nullValidator();
        Validator gradleUserHomeValidator = Validators.optionalDirectoryValidator((String)"Gradle user home");
        this.configuration = new ProjectImportConfiguration(projectDirValidator, gradleDistributionValidator, gradleUserHomeValidator, applyWorkingSetsValidator, workingSetsValidator);
        IDialogSettings dialogSettings = projectImportWizard.getDialogSettings();
        Optional projectDir = FileUtils.getAbsoluteFile((String)dialogSettings.get(SETTINGS_KEY_PROJECT_DIR));
        Optional gradleDistributionType = Optional.fromNullable((Object)Strings.emptyToNull((String)dialogSettings.get(SETTINGS_KEY_GRADLE_DISTRIBUTION_TYPE)));
        Optional gradleDistributionConfiguration = Optional.fromNullable((Object)Strings.emptyToNull((String)dialogSettings.get(SETTINGS_KEY_GRADLE_DISTRIBUTION_CONFIGURATION)));
        Optional gradleUserHome = FileUtils.getAbsoluteFile((String)dialogSettings.get(SETTINGS_KEY_GRADLE_USER_HOME));
        boolean applyWorkingSets = dialogSettings.get(SETTINGS_KEY_APPLY_WORKING_SETS) != null && dialogSettings.getBoolean(SETTINGS_KEY_APPLY_WORKING_SETS);
        ImmutableList workingSets = ImmutableList.copyOf((Object[])CollectionsUtils.nullToEmpty((String[])dialogSettings.getArray(SETTINGS_KEY_WORKING_SETS)));
        boolean buildScansEnabled = dialogSettings.getBoolean(SETTINGS_KEY_BUILD_SCANS);
        boolean offlineMode = dialogSettings.getBoolean(SETTINGS_KEY_OFFLINE_MODE);
        boolean autoSync = dialogSettings.getBoolean(SETTINGS_KEY_AUTO_SYNC);
        this.configuration.setProjectDir((File)projectDir.orNull());
        this.configuration.setOverwriteWorkspaceSettings(false);
        this.configuration.setGradleDistribution(this.createGradleDistribution((Optional<String>)gradleDistributionType, (Optional<String>)gradleDistributionConfiguration));
        this.configuration.setGradleUserHome((File)gradleUserHome.orNull());
        this.configuration.setApplyWorkingSets(Boolean.valueOf(applyWorkingSets));
        this.configuration.setWorkingSets((List)workingSets);
        this.configuration.setBuildScansEnabled(buildScansEnabled);
        this.configuration.setOfflineMode(offlineMode);
        this.configuration.setAutoSync(autoSync);
        this.saveFilePropertyWhenChanged(dialogSettings, SETTINGS_KEY_PROJECT_DIR, (Property<File>)this.configuration.getProjectDir());
        this.saveGradleWrapperPropertyWhenChanged(dialogSettings, (Property<GradleDistributionWrapper>)this.configuration.getGradleDistribution());
        this.saveFilePropertyWhenChanged(dialogSettings, SETTINGS_KEY_GRADLE_USER_HOME, (Property<File>)this.configuration.getGradleUserHome());
        this.saveBooleanPropertyWhenChanged(dialogSettings, SETTINGS_KEY_APPLY_WORKING_SETS, (Property<Boolean>)this.configuration.getApplyWorkingSets());
        this.saveStringArrayPropertyWhenChanged(dialogSettings, SETTINGS_KEY_WORKING_SETS, (Property<List<String>>)this.configuration.getWorkingSets());
        this.saveBooleanPropertyWhenChanged(dialogSettings, SETTINGS_KEY_BUILD_SCANS, (Property<Boolean>)this.configuration.getBuildScansEnabled());
        this.saveBooleanPropertyWhenChanged(dialogSettings, SETTINGS_KEY_OFFLINE_MODE, (Property<Boolean>)this.configuration.getOfflineMode());
        this.saveBooleanPropertyWhenChanged(dialogSettings, SETTINGS_KEY_AUTO_SYNC, (Property<Boolean>)this.configuration.getAutoSync());
    }

    private GradleDistributionWrapper createGradleDistribution(Optional<String> gradleDistributionType, Optional<String> gradleDistributionConfiguration) {
        GradleDistributionWrapper.DistributionType distributionType = GradleDistributionWrapper.DistributionType.valueOf((String)((String)gradleDistributionType.or((Object)GradleDistributionWrapper.DistributionType.WRAPPER.name())));
        String distributionConfiguration = (String)gradleDistributionConfiguration.orNull();
        return GradleDistributionWrapper.from((GradleDistributionWrapper.DistributionType)distributionType, (String)distributionConfiguration);
    }

    private void saveBooleanPropertyWhenChanged(final IDialogSettings settings, final String settingsKey, final Property<Boolean> target) {
        target.addValidationListener(new ValidationListener(){

            public void validationTriggered(Property<?> source, Optional<String> validationErrorMessage) {
                settings.put(settingsKey, ((Boolean)target.getValue()).booleanValue());
            }
        });
    }

    private void saveStringArrayPropertyWhenChanged(final IDialogSettings settings, final String settingsKey, final Property<List<String>> target) {
        target.addValidationListener(new ValidationListener(){

            public void validationTriggered(Property<?> source, Optional<String> validationErrorMessage) {
                List value = (List)target.getValue();
                settings.put(settingsKey, value.toArray(new String[value.size()]));
            }
        });
    }

    private void saveFilePropertyWhenChanged(final IDialogSettings settings, final String settingsKey, final Property<File> target) {
        target.addValidationListener(new ValidationListener(){

            public void validationTriggered(Property<?> source, Optional<String> validationErrorMessage) {
                settings.put(settingsKey, (String)FileUtils.getAbsolutePath((File)((File)target.getValue())).orNull());
            }
        });
    }

    private void saveGradleWrapperPropertyWhenChanged(final IDialogSettings settings, final Property<GradleDistributionWrapper> target) {
        target.addValidationListener(new ValidationListener(){

            public void validationTriggered(Property<?> source, Optional<String> validationErrorMessage) {
                settings.put(ProjectImportWizardController.SETTINGS_KEY_GRADLE_DISTRIBUTION_TYPE, ((GradleDistributionWrapper)target.getValue()).getType().name());
                settings.put(ProjectImportWizardController.SETTINGS_KEY_GRADLE_DISTRIBUTION_CONFIGURATION, ((GradleDistributionWrapper)target.getValue()).getConfiguration());
            }
        });
    }

    public ProjectImportConfiguration getConfiguration() {
        return this.configuration;
    }

    public boolean performImportProject(AsyncHandler initializer, NewProjectHandler newProjectHandler) {
        BuildConfiguration buildConfig = this.configuration.toBuildConfig();
        ImportWizardNewProjectHandler workingSetsAddingNewProjectHandler = new ImportWizardNewProjectHandler(newProjectHandler, this.configuration);
        GradleBuild build = CorePlugin.gradleWorkspaceManager().getGradleBuild(buildConfig);
        build.synchronize((NewProjectHandler)workingSetsAddingNewProjectHandler, initializer);
        return true;
    }

    private static final class ImportWizardNewProjectHandler
    implements NewProjectHandler {
        private final ProjectImportConfiguration configuration;
        private final NewProjectHandler importedBuildDelegate;
        private volatile boolean gradleViewsVisible;

        private ImportWizardNewProjectHandler(NewProjectHandler delegate, ProjectImportConfiguration configuration) {
            this.importedBuildDelegate = delegate;
            this.configuration = configuration;
        }

        public boolean shouldImport(OmniEclipseProject projectModel) {
            return this.importedBuildDelegate.shouldImport(projectModel);
        }

        public void afterImport(IProject project, OmniEclipseProject projectModel) {
            this.importedBuildDelegate.afterImport(project, projectModel);
            this.addWorkingSets(project);
            this.ensureGradleViewsAreVisible();
        }

        private void addWorkingSets(IProject project) {
            ImmutableList workingSetNames = (Boolean)this.configuration.getApplyWorkingSets().getValue() != false ? ImmutableList.copyOf((Collection)((Collection)this.configuration.getWorkingSets().getValue())) : ImmutableList.of();
            IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
            IWorkingSet[] workingSets = WorkingSetUtils.toWorkingSets((List<String>)workingSetNames);
            workingSetManager.addToWorkingSets((IAdaptable)project, workingSets);
        }

        private void ensureGradleViewsAreVisible() {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!ImportWizardNewProjectHandler.this.gradleViewsVisible) {
                        ImportWizardNewProjectHandler.this.gradleViewsVisible = true;
                        WorkbenchUtils.showView("org.eclipse.buildship.ui.views.taskview", null, 1);
                        WorkbenchUtils.showView("org.eclipse.buildship.ui.views.executionview", null, 2);
                    }
                }
            });
        }
    }
}

