/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.marker;

import com.google.common.base.Throwables;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.workspace.InternalGradleBuild;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class GradleErrorMarker {
    public static final String ID = "org.eclipse.buildship.core.errormarker";
    public static final String ATTRIBUTE_STACKTRACE = "stacktrace";
    public static final String ATTRIBUTE_ROOT_DIR = "rootdir";
    public static final String ATTRIBUTE_FQID = "problem.id.fqid";
    public static final String ATTRIBUTE_ID_DISPLAY_NAME = "problem.id.displayname";
    public static final String ATTRIBUTE_LABEL = "problem.label";
    public static final String ATTRIBUTE_DETAILS = "problem.details";
    public static final String ATTRIBUTE_SOLUTIONS = "problem.solutions";
    public static final String ATTRIBUTE_ADDITIONAL_DATA = "problem.additionaldata";
    public static final String ATTRIBUTE_DOCUMENTATION_LINK = "problem.documentationlink";

    private GradleErrorMarker() {
    }

    public static boolean belongsToBuild(IMarker marker, InternalGradleBuild build) {
        String rootDir = marker.getAttribute(ATTRIBUTE_ROOT_DIR, null);
        return build.getBuildConfig().getRootProjectDirectory().getAbsolutePath().equals(rootDir);
    }

    public static void createError(IResource resource, InternalGradleBuild gradleBuild, String message, Throwable exception) {
        GradleErrorMarker.createMarker(2, resource, gradleBuild, message, exception, 0);
    }

    public static void createError(IResource resource, InternalGradleBuild gradleBuild, String message, Throwable exception, int lineNumber) {
        GradleErrorMarker.createMarker(2, resource, gradleBuild, message, exception, lineNumber);
    }

    public static void createWarning(IResource resource, InternalGradleBuild gradleBuild, String message, Throwable exception) {
        GradleErrorMarker.createMarker(1, resource, gradleBuild, message, exception, 0);
    }

    private static void createMarker(int severity, IResource resource, InternalGradleBuild gradleBuild, String message, Throwable exception, int lineNumber) {
        String stacktrace = exception == null ? null : GradleErrorMarker.trimMarkerProperty(Throwables.getStackTraceAsString((Throwable)exception));
        GradleErrorMarker.createMarker(resource, severity, gradleBuild, message, stacktrace, marker -> {
            if (lineNumber >= 0) {
                try {
                    marker.setAttribute("lineNumber", lineNumber);
                }
                catch (CoreException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private static void createMarker(IResource resource, final int severity, final InternalGradleBuild gradleBuild, final String message, final String exception, Consumer<IMarker> customMarkerConfiguration) {
        GradleErrorMarker.createMarker(resource, new Consumer<IMarker>(){

            @Override
            public void accept(IMarker marker) {
                try {
                    marker.setAttribute("priority", 2);
                    marker.setAttribute("severity", severity);
                    marker.setAttribute(GradleErrorMarker.ATTRIBUTE_ROOT_DIR, (Object)gradleBuild.getBuildConfig().getRootProjectDirectory().getAbsolutePath());
                    marker.setAttribute("message", (Object)GradleErrorMarker.trimMarkerProperty(message));
                    if (exception != null) {
                        marker.setAttribute(GradleErrorMarker.ATTRIBUTE_STACKTRACE, (Object)exception);
                    }
                }
                catch (CoreException e) {
                    CorePlugin.logger().warn("Cannot create Gradle error marker", e);
                    throw new RuntimeException(e);
                }
            }
        }.andThen(customMarkerConfiguration));
    }

    private static void createMarker(IResource resource, Consumer<IMarker> markerConfiguration) {
        try {
            IMarker marker = resource.createMarker(ID);
            markerConfiguration.accept(marker);
        }
        catch (Exception e) {
            CorePlugin.logger().warn("Cannot create Gradle error marker", e);
        }
    }

    public static void createProblemMarker(int severity, IResource resource, InternalGradleBuild gradleBuild, String message, String exception, Consumer<IMarker> problemPosition, Consumer<IMarker> problemDetails) {
        GradleErrorMarker.createMarker(resource, severity, gradleBuild, message, exception, problemPosition.andThen(problemDetails));
    }

    private static String trimMarkerProperty(String property) {
        if (property.length() < 16384) {
            return property;
        }
        byte[] bytes = property.getBytes(StandardCharsets.UTF_8);
        if (bytes.length <= 65535) {
            return property;
        }
        return new String(bytes, 0, 65535, StandardCharsets.UTF_8);
    }
}

