/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.gradle;

import com.google.common.collect.ImmutableList;
import java.lang.invoke.CallSite;
import java.util.List;
import org.eclipse.buildship.core.internal.util.gradle.GradleVersion;
import org.eclipse.buildship.core.internal.util.gradle.Pair;

public final class MissingFeatures {
    private final GradleVersion targetVersion;

    public MissingFeatures(GradleVersion targetVersion) {
        this.targetVersion = targetVersion;
    }

    public List<Pair<GradleVersion, String>> getMissingFeatures() {
        ImmutableList.Builder missingFeatures = ImmutableList.builder();
        this.addIfNeeded("2.7", "Test classes and methods can be run from the Editor", (ImmutableList.Builder<Pair<GradleVersion, String>>)missingFeatures);
        this.addIfNeeded("2.9", "Custom project natures and build commands are added", (ImmutableList.Builder<Pair<GradleVersion, String>>)missingFeatures);
        this.addIfNeeded("2.10", "Language source level is set on Java projects", (ImmutableList.Builder<Pair<GradleVersion, String>>)missingFeatures);
        this.addIfNeeded("2.11", "Target bytecode version is set on Java projects", (ImmutableList.Builder<Pair<GradleVersion, String>>)missingFeatures);
        this.addIfNeeded("2.11", "Java runtime is set on Java projects", (ImmutableList.Builder<Pair<GradleVersion, String>>)missingFeatures);
        this.addIfNeeded("2.13", "Improved performance when loading models", (ImmutableList.Builder<Pair<GradleVersion, String>>)missingFeatures);
        this.addIfNeeded("2.14", "Attributes defined for Java classpath entries", (ImmutableList.Builder<Pair<GradleVersion, String>>)missingFeatures);
        this.addIfNeeded("2.14", "WTP deployment attributes defined for web projects", (ImmutableList.Builder<Pair<GradleVersion, String>>)missingFeatures);
        this.addIfNeeded("3.0", "Output location, classpath containers, source folder excludes-includes and JRE name are set on Java projects", (ImmutableList.Builder<Pair<GradleVersion, String>>)missingFeatures);
        this.addIfNeeded("3.0", "Java classpath customization done in 'eclipse.classpath.file.whenMerged' is synchronized", (ImmutableList.Builder<Pair<GradleVersion, String>>)missingFeatures);
        this.addIfNeeded("3.3", "Support for composite builds", (ImmutableList.Builder<Pair<GradleVersion, String>>)missingFeatures);
        this.addIfNeeded("5.4", "Run tasks upon synchronization", (ImmutableList.Builder<Pair<GradleVersion, String>>)missingFeatures);
        this.addIfNeeded("5.5", "Import projects with overlapping names", (ImmutableList.Builder<Pair<GradleVersion, String>>)missingFeatures);
        this.addIfNeeded("5.6", "Receive compile-time error when referencing test source in main source set", (ImmutableList.Builder<Pair<GradleVersion, String>>)missingFeatures);
        this.addIfNeeded("5.6", "Substitute closed project references with their publications", (ImmutableList.Builder<Pair<GradleVersion, String>>)missingFeatures);
        this.addIfNeeded("5.6", "Test debugging", (ImmutableList.Builder<Pair<GradleVersion, String>>)missingFeatures);
        this.addIfNeeded("6.8", "Task execution in included builds", (ImmutableList.Builder<Pair<GradleVersion, String>>)missingFeatures);
        return missingFeatures.build();
    }

    private void addIfNeeded(String version, String missingFeature, ImmutableList.Builder<Pair<GradleVersion, String>> missingFeatures) {
        GradleVersion gradleVersion = GradleVersion.version(version);
        if (this.targetVersion.getBaseVersion().compareTo(gradleVersion) < 0) {
            missingFeatures.add(this.createLimitation(gradleVersion, missingFeature));
        }
    }

    private Pair<GradleVersion, String> createLimitation(GradleVersion version, String missingFeature) {
        return new Pair<GradleVersion, CallSite>(version, (CallSite)((Object)(missingFeature + " since " + String.valueOf(version) + ".")));
    }
}

