/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.wizard.project;

import com.google.common.base.Optional;
import java.io.File;
import org.eclipse.buildship.core.internal.util.binding.Property;
import org.eclipse.buildship.core.internal.util.binding.ValidationListener;
import org.eclipse.buildship.core.internal.util.binding.Validator;
import org.eclipse.buildship.core.internal.util.binding.Validators;
import org.eclipse.buildship.core.internal.util.file.FileUtils;
import org.eclipse.buildship.ui.internal.wizard.project.ProjectCreationConfiguration;
import org.eclipse.buildship.ui.internal.wizard.project.ProjectWizardMessages;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.ui.INewWizard;

public final class ProjectCreationWizardController {
    private static final String SETTINGS_KEY_LOCATION_USE_DEFAULT = "use_default_location";
    private static final String SETTINGS_KEY_CUSTOM_LOCATION = "custom_location";
    private final ProjectCreationConfiguration configuration;

    public ProjectCreationWizardController(INewWizard projectCreationWizard) {
        Property projectNameProperty = Property.create((Validator)Validators.uniqueWorkspaceProjectNameValidator((String)ProjectWizardMessages.Label_ProjectName));
        Property useDefaultLocationProperty = Property.create((Validator)Validators.nullValidator());
        Property customLocationProperty = Property.create((Validator)Validators.validateIfConditionFalse((Validator)Validators.requiredDirectoryValidator((String)ProjectWizardMessages.Label_CustomLocation), (Property)useDefaultLocationProperty));
        Property targetProjectDirProperty = Property.create((Validator)Validators.nonExistentDirectoryValidator((String)ProjectWizardMessages.Message_TargetProjectDirectory));
        this.configuration = new ProjectCreationConfiguration((Property<String>)projectNameProperty, (Property<Boolean>)useDefaultLocationProperty, (Property<File>)customLocationProperty, (Property<File>)targetProjectDirProperty);
        IDialogSettings dialogSettings = projectCreationWizard.getDialogSettings();
        boolean useDefaultLocation = dialogSettings.get(SETTINGS_KEY_LOCATION_USE_DEFAULT) == null || dialogSettings.getBoolean(SETTINGS_KEY_LOCATION_USE_DEFAULT);
        Optional customLocation = FileUtils.getAbsoluteFile((String)dialogSettings.get(SETTINGS_KEY_CUSTOM_LOCATION));
        this.configuration.setUseDefaultLocation(useDefaultLocation);
        this.configuration.setCustomLocation((File)customLocation.orNull());
        this.saveBooleanPropertyWhenChanged(dialogSettings, SETTINGS_KEY_LOCATION_USE_DEFAULT, this.configuration.getUseDefaultLocation());
        this.saveFilePropertyWhenChanged(dialogSettings, SETTINGS_KEY_CUSTOM_LOCATION, this.configuration.getCustomLocation());
    }

    private void saveBooleanPropertyWhenChanged(final IDialogSettings settings, final String settingsKey, final Property<Boolean> target) {
        target.addValidationListener(new ValidationListener(){

            public void validationTriggered(Property<?> source, Optional<String> validationErrorMessage) {
                settings.put(settingsKey, ((Boolean)target.getValue()).booleanValue());
            }
        });
    }

    private void saveFilePropertyWhenChanged(final IDialogSettings settings, final String settingsKey, final Property<File> target) {
        target.addValidationListener(new ValidationListener(){

            public void validationTriggered(Property<?> source, Optional<String> validationErrorMessage) {
                settings.put(settingsKey, (String)FileUtils.getAbsolutePath((File)((File)target.getValue())).orNull());
            }
        });
    }

    public ProjectCreationConfiguration getConfiguration() {
        return this.configuration;
    }
}

