/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.wizard.project;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Optional;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.internal.configuration.BuildConfiguration;
import org.eclipse.buildship.core.internal.gradle.MissingFeatures;
import org.eclipse.buildship.core.internal.i18n.CoreMessages;
import org.eclipse.buildship.core.internal.operation.BaseToolingApiOperation;
import org.eclipse.buildship.core.internal.operation.ToolingApiOperation;
import org.eclipse.buildship.core.internal.operation.ToolingApiOperations;
import org.eclipse.buildship.core.internal.operation.ToolingApiStatus;
import org.eclipse.buildship.core.internal.util.binding.Property;
import org.eclipse.buildship.core.internal.util.gradle.GradleVersion;
import org.eclipse.buildship.core.internal.util.gradle.Pair;
import org.eclipse.buildship.core.internal.workspace.FetchStrategy;
import org.eclipse.buildship.core.internal.workspace.InitializeNewProjectOperation;
import org.eclipse.buildship.core.internal.workspace.ModelProvider;
import org.eclipse.buildship.ui.internal.util.font.FontUtils;
import org.eclipse.buildship.ui.internal.util.gradle.GradleDistributionViewModel;
import org.eclipse.buildship.ui.internal.util.layout.LayoutUtils;
import org.eclipse.buildship.ui.internal.util.widget.UiBuilder;
import org.eclipse.buildship.ui.internal.wizard.project.AbstractWizardPage;
import org.eclipse.buildship.ui.internal.wizard.project.ProjectImportConfiguration;
import org.eclipse.buildship.ui.internal.wizard.project.ProjectWizardMessages;
import org.eclipse.buildship.ui.internal.wizard.project.WizardHelper;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.PageBook;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.build.GradleEnvironment;
import org.gradle.tooling.model.gradle.BasicGradleProject;
import org.gradle.tooling.model.gradle.GradleBuild;

public final class ProjectPreviewWizardPage
extends AbstractWizardPage {
    private final Font keyFont = FontUtils.getCustomDialogFont(1);
    private final Font valueFont = FontUtils.getCustomDialogFont(0);
    private Label projectDirLabel;
    private Label gradleUserHomeLabel;
    private Label gradleDistributionLabel;
    private Label gradleVersionLabel;
    private Label gradleVersionWarningLabel;
    private Label javaHomeLabel;
    private PageBook previewResultPages;
    private Tree previewResultSuccessTree;
    private Text previewResultErrorText;

    public ProjectPreviewWizardPage(ProjectImportConfiguration configuration) {
        this(configuration, ProjectWizardMessages.Title_PreviewImportWizardPage, ProjectWizardMessages.InfoMessage_GradlePreviewWizardPageDefault);
    }

    public ProjectPreviewWizardPage(ProjectImportConfiguration configuration, String title, String defaultMessage) {
        super("ProjectPreview", title, defaultMessage, configuration, (List<Property<?>>)ImmutableList.of());
    }

    @Override
    protected void createWidgets(Composite root) {
        root.setLayout(this.createLayout());
        this.createContent(root);
    }

    private Layout createLayout() {
        GridLayout layout = LayoutUtils.newGridLayout(2);
        layout.horizontalSpacing = 4;
        layout.verticalSpacing = 4;
        return layout;
    }

    private void createContent(Composite root) {
        this.createSummaryLabels(root);
        this.createPreviewGroup(root);
        this.updatePreviewLabels(this.getConfiguration());
    }

    private void createSummaryLabels(Composite container) {
        UiBuilder.UiBuilderFactory uiBuilderFactory = this.getUiBuilderFactory();
        uiBuilderFactory.newLabel(container).text(ProjectWizardMessages.Label_ProjectRootDirectory + ":").font(this.keyFont).alignLeft();
        this.projectDirLabel = uiBuilderFactory.newLabel(container).alignFillHorizontal().disabled().font(this.valueFont).control();
        this.createSpacingRow(container, 2);
        uiBuilderFactory.newLabel(container).text(ProjectWizardMessages.Label_GradleUserHome + ":").font(this.keyFont).alignLeft();
        this.gradleUserHomeLabel = uiBuilderFactory.newLabel(container).alignFillHorizontal().disabled().font(this.valueFont).control();
        uiBuilderFactory.newLabel(container).text(ProjectWizardMessages.Label_GradleDistribution + ":").font(this.keyFont).alignLeft();
        this.gradleDistributionLabel = uiBuilderFactory.newLabel(container).alignFillHorizontal().disabled().font(this.valueFont).control();
        uiBuilderFactory.newLabel(container).text(ProjectWizardMessages.Label_GradleVersion + ":").font(this.keyFont).alignLeft();
        Composite gradleVersionContainer = new Composite(container, 0);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)gradleVersionContainer);
        GridLayoutFactory.swtDefaults().margins(0, 0).extendedMargins(0, 0, 0, 0).spacing(0, 0).numColumns(2).applyTo(gradleVersionContainer);
        this.gradleVersionLabel = uiBuilderFactory.newLabel(gradleVersionContainer).alignLeft().disabled().font(this.valueFont).control();
        this.gradleVersionWarningLabel = uiBuilderFactory.newLabel(gradleVersionContainer).alignLeft().control();
        this.gradleVersionWarningLabel.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK"));
        this.gradleVersionWarningLabel.setCursor(gradleVersionContainer.getDisplay().getSystemCursor(21));
        this.gradleVersionWarningLabel.setToolTipText(ProjectWizardMessages.Missing_Features_Tooltip);
        this.gradleVersionWarningLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                String version = ProjectPreviewWizardPage.this.gradleVersionLabel.getText();
                MissingFeatures limitations = new MissingFeatures(GradleVersion.version((String)version));
                FluentIterable limitationMessages = FluentIterable.from((Iterable)limitations.getMissingFeatures()).transform((Function)new Function<Pair<GradleVersion, String>, String>(this){

                    public String apply(Pair<GradleVersion, String> limitation) {
                        return (String)limitation.getSecond();
                    }
                });
                String message = NLS.bind((String)ProjectWizardMessages.Missing_Features_Details_0_1, (Object)version, (Object)Joiner.on((char)'\n').join((Iterable)limitationMessages));
                MessageDialog.openInformation((Shell)ProjectPreviewWizardPage.this.getShell(), (String)ProjectWizardMessages.Title_Dialog_Missing_Features, (String)message);
            }
        });
        this.createSpacingRow(container, 2);
        uiBuilderFactory.newLabel(container).text(ProjectWizardMessages.Label_JavaHome + ":").font(this.keyFont).alignLeft();
        this.javaHomeLabel = uiBuilderFactory.newLabel(container).alignFillHorizontal().disabled().font(this.valueFont).control();
    }

    private void createPreviewGroup(Composite container) {
        UiBuilder.UiBuilderFactory uiBuilderFactory = this.getUiBuilderFactory();
        this.createSpacingRow(container, 2);
        uiBuilderFactory.newLabel(container).text(ProjectWizardMessages.Label_ProjectStructure + ":").font(this.keyFont).alignLeft();
        Label previewStructureInfoLabel = uiBuilderFactory.newLabel(container).alignLeft().control();
        previewStructureInfoLabel.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK"));
        previewStructureInfoLabel.setCursor(container.getDisplay().getSystemCursor(21));
        previewStructureInfoLabel.setToolTipText(ProjectWizardMessages.PreviewStructureInfo_Tooltip);
        previewStructureInfoLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                MessageDialog.openInformation((Shell)ProjectPreviewWizardPage.this.getShell(), (String)ProjectWizardMessages.Title_Dialog_PreviewStructureInfo, (String)ProjectWizardMessages.PreviewStructureInfo_Details);
            }
        });
        this.previewResultPages = new PageBook(container, 0);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, true).applyTo((Control)this.previewResultPages);
        this.previewResultSuccessTree = new Tree((Composite)this.previewResultPages, 0);
        this.previewResultErrorText = new Text((Composite)this.previewResultPages, 2826);
        this.previewResultPages.showPage((Control)this.previewResultSuccessTree);
    }

    private void createSpacingRow(Composite container, int horizontalSpan) {
        GridData data = new GridData(16384, 0x1000000, false, false, horizontalSpan, 1);
        data.heightHint = 8;
        new Label(container, 0).setLayoutData((Object)data);
    }

    private void updatePreviewLabels(ProjectImportConfiguration configuration) {
        this.updateFileLabel(this.projectDirLabel, configuration.getProjectDir(), CoreMessages.Value_UseGradleDefault);
        this.updateGradleDistributionLabel(this.gradleDistributionLabel, configuration.getDistribution(), CoreMessages.Value_UseGradleDefault);
        this.updateGradleVersionLabel(this.gradleVersionLabel, configuration.getDistribution(), CoreMessages.Value_Unknown);
        this.gradleUserHomeLabel.setText(CoreMessages.Value_Unknown);
        this.javaHomeLabel.setText(CoreMessages.Value_Unknown);
        this.updateGradleVersionWarningLabel();
    }

    private void updateFileLabel(Label target, Property<File> source, String defaultMessage) {
        File file = (File)source.getValue();
        target.setText(file != null ? file.getAbsolutePath() : defaultMessage);
    }

    private void updateGradleDistributionLabel(Label target, Property<GradleDistributionViewModel> distributionProperty, String defaultMessage) {
        GradleDistributionViewModel distribution = (GradleDistributionViewModel)distributionProperty.getValue();
        target.setText(distribution != null ? distribution.toString() : defaultMessage);
    }

    private void updateGradleVersionLabel(Label target, Property<GradleDistributionViewModel> gradleDistribution, String defaultMessage) {
        GradleDistributionViewModel distribution = (GradleDistributionViewModel)gradleDistribution.getValue();
        if (distribution == null) {
            target.setText(defaultMessage);
            return;
        }
        Optional<GradleDistributionViewModel.Type> typeOrNull = distribution.getType();
        if (!typeOrNull.isPresent()) {
            target.setText(defaultMessage);
        } else {
            GradleDistributionViewModel.Type type = typeOrNull.get();
            switch (type) {
                case WRAPPER: 
                case LOCAL_INSTALLATION: 
                case REMOTE_DISTRIBUTION: {
                    target.setText(defaultMessage);
                    break;
                }
                case VERSION: {
                    target.setText(distribution.getConfiguration());
                    break;
                }
                default: {
                    throw new GradlePluginsRuntimeException("Unrecognized Gradle distribution type: " + String.valueOf(distribution.getType()));
                }
            }
        }
        target.getParent().layout();
    }

    private void updateGradleVersionWarningLabel() {
        try {
            GradleVersion version = GradleVersion.version((String)this.gradleVersionLabel.getText());
            MissingFeatures missingFeatures = new MissingFeatures(version);
            this.gradleVersionWarningLabel.setVisible(!missingFeatures.getMissingFeatures().isEmpty());
        }
        catch (IllegalArgumentException e) {
            this.gradleVersionWarningLabel.setVisible(false);
        }
        this.gradleVersionLabel.getParent().layout();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.updatePreviewLabels(this.getConfiguration());
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ProjectPreviewWizardPage.this.scheduleProjectPreviewJob();
                }
            });
        }
    }

    private void scheduleProjectPreviewJob() {
        IWizardContainer container = this.getContainer();
        if (container == null) {
            return;
        }
        try {
            container.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                    try {
                        BuildConfiguration buildConfig = ProjectPreviewWizardPage.this.getConfiguration().toInternalBuildConfiguration();
                        InitializeNewProjectOperation initializeOperation = new InitializeNewProjectOperation(buildConfig);
                        UpdatePreviewOperation updatePreviewOperation = new UpdatePreviewOperation(buildConfig);
                        CorePlugin.operationManager().run(ToolingApiOperations.concat((ToolingApiOperation)initializeOperation, (ToolingApiOperation)updatePreviewOperation), monitor);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            ToolingApiStatus status = WizardHelper.containerExceptionToToolingApiStatus(e);
            if (ToolingApiStatus.ToolingApiStatusType.BUILD_CANCELLED.matches(status)) {
                this.previewCancelled();
            } else {
                this.previewFailed(status);
            }
        }
        catch (InterruptedException ignored) {
            this.previewCancelled();
        }
    }

    private void previewFinished(final BuildEnvironment buildEnvironment, final GradleBuild gradleBuild) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ProjectPreviewWizardPage.this.setErrorMessage(null);
                ProjectPreviewWizardPage.this.updateSummary(buildEnvironment);
                ProjectPreviewWizardPage.this.showResultTree(gradleBuild);
            }
        });
    }

    private void previewCancelled() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ProjectPreviewWizardPage.this.setErrorMessage(ProjectWizardMessages.Preview_Cancelled);
                ProjectPreviewWizardPage.this.showEmptyResultTree();
            }
        });
    }

    private void previewFailed(ToolingApiStatus status) {
        status.log();
        Throwable t = status.getException();
        final String stacktrace = t == null ? ProjectWizardMessages.Preview_No_Stacktrace : Throwables.getStackTraceAsString((Throwable)t);
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ProjectPreviewWizardPage.this.setErrorMessage(ProjectWizardMessages.Preview_Failed);
                ProjectPreviewWizardPage.this.showExceptionText(stacktrace);
            }
        });
    }

    private void updateSummary(BuildEnvironment buildEnvironment) {
        if (!this.getControl().isDisposed()) {
            String gradleUserHome = this.getGradleUserHomePath(buildEnvironment);
            this.gradleUserHomeLabel.setText(gradleUserHome);
            String gradleVersion = buildEnvironment.getGradle().getGradleVersion();
            this.gradleVersionLabel.setText(gradleVersion);
            this.updateGradleVersionWarningLabel();
            String javaHome = buildEnvironment.getJava().getJavaHome().getAbsolutePath();
            this.javaHomeLabel.setText(javaHome);
        }
    }

    private String getGradleUserHomePath(BuildEnvironment buildEnvironment) {
        File gradleUserHome = this.getGradleUserHome(buildEnvironment.getGradle());
        return gradleUserHome == null ? "" : gradleUserHome.getAbsolutePath();
    }

    private File getGradleUserHome(GradleEnvironment gradleEnvironment) {
        try {
            return gradleEnvironment.getGradleUserHome();
        }
        catch (Exception ignore) {
            return null;
        }
    }

    private void showResultTree(GradleBuild buildStructure) {
        if (!this.getControl().isDisposed()) {
            this.previewResultSuccessTree.removeAll();
            this.populateRecursively(buildStructure, this.previewResultSuccessTree);
            this.previewResultPages.showPage((Control)this.previewResultSuccessTree);
        }
    }

    private void showEmptyResultTree() {
        if (!this.getControl().isDisposed()) {
            this.previewResultSuccessTree.removeAll();
            this.previewResultPages.showPage((Control)this.previewResultSuccessTree);
        }
    }

    private void showExceptionText(String stackTrace) {
        if (!this.getControl().isDisposed()) {
            this.previewResultErrorText.setText(stackTrace);
            this.previewResultPages.showPage((Control)this.previewResultErrorText);
        }
    }

    private void populateRecursively(GradleBuild gradleBuild, Tree parent) {
        BasicGradleProject rootProject = gradleBuild.getRootProject();
        TreeItem rootTreeItem = new TreeItem(this.previewResultSuccessTree, 0);
        rootTreeItem.setExpanded(true);
        rootTreeItem.setText(rootProject.getName());
        this.populateRecursively(rootProject, rootTreeItem);
        for (GradleBuild includedBuilds : gradleBuild.getIncludedBuilds()) {
            this.populateRecursively(includedBuilds, parent);
        }
    }

    private void populateRecursively(BasicGradleProject gradleProject, TreeItem parent) {
        for (BasicGradleProject childProject : gradleProject.getChildren()) {
            TreeItem treeItem = new TreeItem(parent, 0);
            treeItem.setText(childProject.getName());
            this.populateRecursively(childProject, treeItem);
        }
    }

    public void dispose() {
        this.keyFont.dispose();
        this.valueFont.dispose();
        super.dispose();
    }

    private static BuildEnvironment fetchBuildEnvironment(BuildConfiguration buildConfig, CancellationTokenSource tokenSource, IProgressMonitor monitor) {
        ModelProvider modelProvider = CorePlugin.internalGradleWorkspace().getGradleBuild(buildConfig).getModelProvider();
        return (BuildEnvironment)modelProvider.fetchModel(BuildEnvironment.class, FetchStrategy.FORCE_RELOAD, tokenSource, monitor);
    }

    private static GradleBuild fetchGradleBuildStructure(BuildConfiguration buildConfig, CancellationTokenSource tokenSource, IProgressMonitor monitor) {
        ModelProvider modelProvider = CorePlugin.internalGradleWorkspace().getGradleBuild(buildConfig).getModelProvider();
        return (GradleBuild)modelProvider.fetchModel(GradleBuild.class, FetchStrategy.FORCE_RELOAD, tokenSource, monitor);
    }

    private class UpdatePreviewOperation
    extends BaseToolingApiOperation {
        private final BuildConfiguration buildConfig;

        public UpdatePreviewOperation(BuildConfiguration buildConfig) {
            super("Update preview");
            this.buildConfig = buildConfig;
        }

        public void runInToolingApi(CancellationTokenSource tokenSource, IProgressMonitor monitor) throws Exception {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
            progress.setWorkRemaining(2);
            BuildEnvironment buildEnvironment = ProjectPreviewWizardPage.fetchBuildEnvironment(this.buildConfig, tokenSource, (IProgressMonitor)progress.newChild(1));
            GradleBuild gradleBuild = ProjectPreviewWizardPage.fetchGradleBuildStructure(this.buildConfig, tokenSource, (IProgressMonitor)progress.newChild(1));
            ProjectPreviewWizardPage.this.previewFinished(buildEnvironment, gradleBuild);
        }

        public ISchedulingRule getRule() {
            return ResourcesPlugin.getWorkspace().getRoot();
        }
    }
}

