/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.preferences;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.eclipse.buildship.core.internal.preferences.PersistentModel;
import org.eclipse.buildship.core.internal.util.gradle.GradleVersion;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;

public final class DefaultPersistentModel
implements PersistentModel {
    private final IProject project;
    private final IPath buildDir;
    private final IPath buildScriptPath;
    private final Collection<IPath> subprojectPaths;
    private final List<IClasspathEntry> classpath;
    private final Collection<IPath> derivedResources;
    private final Collection<IPath> linkedResources;
    private final List<String> managedNatures;
    private final List<ICommand> managedBuilders;
    private final boolean hasAutoBuildTasks;
    private final GradleVersion gradleVersion;

    public DefaultPersistentModel(IProject project, IPath buildDir, IPath buildScriptPath, Collection<IPath> subprojectPaths, List<IClasspathEntry> classpath, Collection<IPath> derivedResources, Collection<IPath> linkedResources, Collection<String> managedNatures, Collection<ICommand> managedBuilders, boolean hasAutoBuildTasks, GradleVersion gradleVersion) {
        this.project = (IProject)Preconditions.checkNotNull((Object)project);
        this.buildDir = (IPath)Preconditions.checkNotNull((Object)buildDir);
        this.buildScriptPath = (IPath)Preconditions.checkNotNull((Object)buildScriptPath);
        this.subprojectPaths = ImmutableList.copyOf(subprojectPaths);
        this.classpath = ImmutableList.copyOf(classpath);
        this.derivedResources = ImmutableList.copyOf(derivedResources);
        this.linkedResources = ImmutableList.copyOf(linkedResources);
        this.managedNatures = ImmutableList.copyOf(managedNatures);
        this.managedBuilders = ImmutableList.copyOf(managedBuilders);
        this.hasAutoBuildTasks = hasAutoBuildTasks;
        this.gradleVersion = gradleVersion;
    }

    @Override
    public boolean isPresent() {
        return true;
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public IPath getBuildDir() {
        return this.buildDir;
    }

    @Override
    public IPath getbuildScriptPath() {
        return this.buildScriptPath;
    }

    @Override
    public Collection<IPath> getSubprojectPaths() {
        return this.subprojectPaths;
    }

    @Override
    public List<IClasspathEntry> getClasspath() {
        return this.classpath;
    }

    @Override
    public Collection<IPath> getDerivedResources() {
        return this.derivedResources;
    }

    @Override
    public Collection<IPath> getLinkedResources() {
        return this.linkedResources;
    }

    @Override
    public List<String> getManagedNatures() {
        return this.managedNatures;
    }

    @Override
    public List<ICommand> getManagedBuilders() {
        return this.managedBuilders;
    }

    @Override
    public boolean hasAutoBuildTasks() {
        return this.hasAutoBuildTasks;
    }

    @Override
    public GradleVersion getGradleVersion() {
        return this.gradleVersion;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DefaultPersistentModel)) {
            return false;
        }
        DefaultPersistentModel that = (DefaultPersistentModel)obj;
        return Objects.equal((Object)this.project, (Object)that.project) && Objects.equal((Object)this.buildDir, (Object)that.buildDir) && Objects.equal(this.subprojectPaths, that.subprojectPaths) && Objects.equal(this.classpath, that.classpath) && Objects.equal(this.derivedResources, that.derivedResources) && Objects.equal(this.linkedResources, that.linkedResources) && Objects.equal(this.managedNatures, that.managedNatures) && Objects.equal(this.managedBuilders, that.managedBuilders) && Objects.equal((Object)this.hasAutoBuildTasks, (Object)that.hasAutoBuildTasks) && Objects.equal((Object)this.gradleVersion, (Object)that.gradleVersion);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.project, this.buildDir, this.subprojectPaths, this.classpath, this.derivedResources, this.linkedResources, this.managedNatures, this.managedBuilders, this.hasAutoBuildTasks, this.gradleVersion});
    }
}

