/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.view.task;

import com.google.common.base.Optional;
import com.gradleware.tooling.toolingmodel.OmniGradleScript;
import com.gradleware.tooling.toolingmodel.util.Maybe;
import java.io.File;
import org.eclipse.buildship.ui.util.editor.EditorUtils;
import org.eclipse.buildship.ui.util.nodeselection.NodeSelection;
import org.eclipse.buildship.ui.view.task.OpenBuildScriptAction;
import org.eclipse.buildship.ui.view.task.ProjectNode;
import org.eclipse.buildship.ui.view.task.SelectionDependentHandler;
import org.eclipse.core.commands.ExecutionEvent;

public final class OpenBuildScriptHandler
extends SelectionDependentHandler {
    @Override
    protected boolean isEnabledFor(NodeSelection selection) {
        return OpenBuildScriptAction.isEnabledForSelection(selection);
    }

    public Object execute(ExecutionEvent event) {
        NodeSelection selectionHistory = this.getSelectionHistory(event);
        for (ProjectNode projectNode : selectionHistory.getNodes(ProjectNode.class)) {
            Optional<File> buildScript = this.getBuildScriptFor(projectNode);
            if (!buildScript.isPresent()) continue;
            EditorUtils.openInInternalEditor((File)buildScript.get(), true);
        }
        return null;
    }

    private Optional<File> getBuildScriptFor(ProjectNode projectNode) {
        Maybe buildScript = projectNode.getGradleProject().getBuildScript();
        return buildScript.isPresent() ? Optional.fromNullable((Object)((OmniGradleScript)buildScript.get()).getSourceFile()) : Optional.absent();
    }
}

