/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.composite.internal.deduplication;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ResultHandler;
import org.gradle.tooling.composite.CompositeBuildConnection;
import org.gradle.tooling.composite.ModelResult;
import org.gradle.tooling.composite.internal.DefaultModelResult;
import org.gradle.tooling.composite.internal.DelegatingModelBuilder;
import org.gradle.tooling.composite.internal.deduplication.EclipseProjectDeduplicator;
import org.gradle.tooling.model.eclipse.EclipseProject;

public class DeduplicatingCompositeBuildConnection
implements CompositeBuildConnection {
    private final CompositeBuildConnection delegate;

    public DeduplicatingCompositeBuildConnection(CompositeBuildConnection delegate) {
        this.delegate = delegate;
    }

    @Override
    public <T> Set<ModelResult<T>> getModels(Class<T> modelType) throws GradleConnectionException, IllegalStateException, IllegalArgumentException {
        return (Set)this.models(modelType).get();
    }

    @Override
    public <T> ModelBuilder<Set<ModelResult<T>>> models(Class<T> modelType) throws GradleConnectionException, IllegalStateException, IllegalArgumentException {
        ModelBuilder<Set<ModelResult<T>>> models = this.delegate.models(modelType);
        if (modelType == EclipseProject.class) {
            DeduplicatingEclipseModelBuilder builder = new DeduplicatingEclipseModelBuilder((ModelBuilder<Set<ModelResult<EclipseProject>>>)models);
            return builder;
        }
        return models;
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    private static class DeduplicatingEclipseModelBuilder
    extends DelegatingModelBuilder<Set<ModelResult<EclipseProject>>> {
        public DeduplicatingEclipseModelBuilder(ModelBuilder<Set<ModelResult<EclipseProject>>> delegate) {
            super(delegate);
        }

        @Override
        public Set<ModelResult<EclipseProject>> get() throws GradleConnectionException, IllegalStateException {
            Set result = (Set)super.get();
            return this.deduplicate(result);
        }

        @Override
        public void get(ResultHandler<? super Set<ModelResult<EclipseProject>>> handler) throws IllegalStateException {
            this.delegate.get((ResultHandler)new DeduplicatingResultHandler(handler));
        }

        private Set<ModelResult<EclipseProject>> deduplicate(Set<ModelResult<EclipseProject>> eclipseProjects) {
            HashSet unwrappedProjects = Sets.newHashSet();
            for (ModelResult<EclipseProject> modelResult : eclipseProjects) {
                unwrappedProjects.add(modelResult.getModel());
            }
            Set<EclipseProject> deduplicatedProjects = new EclipseProjectDeduplicator().deduplicate(unwrappedProjects);
            HashSet deduplicatedModelResults = Sets.newHashSet();
            for (EclipseProject deduplicatedProject : deduplicatedProjects) {
                deduplicatedModelResults.add(new DefaultModelResult<EclipseProject>(deduplicatedProject));
            }
            return deduplicatedModelResults;
        }

        private final class DeduplicatingResultHandler
        implements ResultHandler<Set<ModelResult<EclipseProject>>> {
            private final ResultHandler<? super Set<ModelResult<EclipseProject>>> delegate;

            private DeduplicatingResultHandler(ResultHandler<? super Set<ModelResult<EclipseProject>>> handler) {
                this.delegate = handler;
            }

            public void onComplete(Set<ModelResult<EclipseProject>> result) {
                this.delegate.onComplete((Object)DeduplicatingEclipseModelBuilder.this.deduplicate(result));
            }

            public void onFailure(GradleConnectionException failure) {
                this.delegate.onFailure(failure);
            }
        }
    }
}

