/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.view.execution;

import com.google.common.base.Preconditions;
import org.eclipse.buildship.ui.PluginImage;
import org.eclipse.buildship.ui.PluginImages;
import org.eclipse.buildship.ui.view.Page;
import org.eclipse.buildship.ui.view.execution.ExecutionViewMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;

public final class SwitchToConsoleViewAction
extends Action {
    private final Page page;

    public SwitchToConsoleViewAction(Page page) {
        this.page = (Page)Preconditions.checkNotNull((Object)page);
        this.setToolTipText(ExecutionViewMessages.Action_SwitchToConsole_Tooltip);
        this.setImageDescriptor(PluginImages.SWITCH_TO_CONSOLE.withState(PluginImage.ImageState.ENABLED).getImageDescriptor());
    }

    public void run() {
        IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        for (IConsole console : consoleManager.getConsoles()) {
            if (!this.page.getDisplayName().equals(console.getName())) continue;
            consoleManager.showConsoleView(console);
            return;
        }
    }
}

