/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import java.util.Set;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.configuration.GradleProjectNature;
import org.eclipse.buildship.core.configuration.ProjectConfiguration;
import org.eclipse.buildship.core.workspace.CompositeGradleBuild;
import org.eclipse.buildship.core.workspace.GradleBuild;
import org.eclipse.buildship.core.workspace.GradleWorkspaceManager;
import org.eclipse.buildship.core.workspace.internal.DefaultCompositeGradleBuild;
import org.eclipse.buildship.core.workspace.internal.DefaultGradleBuild;
import org.eclipse.core.resources.IProject;

public class DefaultGradleWorkspaceManager
implements GradleWorkspaceManager {
    @Override
    public GradleBuild getGradleBuild(FixedRequestAttributes attributes) {
        return new DefaultGradleBuild(attributes);
    }

    @Override
    public Optional<GradleBuild> getGradleBuild(IProject project) {
        Set<FixedRequestAttributes> builds = this.getBuilds((Set<IProject>)ImmutableSet.of((Object)project));
        if (builds.isEmpty()) {
            return Optional.absent();
        }
        return Optional.of((Object)this.getGradleBuild(builds.iterator().next()));
    }

    @Override
    public CompositeGradleBuild getCompositeBuild(Set<IProject> projects) {
        return new DefaultCompositeGradleBuild(this.getBuilds(projects));
    }

    private Set<FixedRequestAttributes> getBuilds(Set<IProject> projects) {
        return FluentIterable.from(projects).filter(GradleProjectNature.isPresentOn()).transform((Function)new Function<IProject, FixedRequestAttributes>(){

            public FixedRequestAttributes apply(IProject project) {
                Optional<ProjectConfiguration> configuration = CorePlugin.projectConfigurationManager().tryReadProjectConfiguration(project);
                return configuration.isPresent() ? ((ProjectConfiguration)configuration.get()).getRequestAttributes() : null;
            }
        }).filter(Predicates.notNull()).toSet();
    }
}

