/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.configuration.internal;

import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.configuration.GradleProjectMarker;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

final class GradleProjectValidationResourceDeltaVisitor
implements IResourceDeltaVisitor {
    private final GradleProjectValidator gradleProjectValidator;

    GradleProjectValidationResourceDeltaVisitor(IProject project) {
        this.gradleProjectValidator = new GradleProjectValidator(project);
    }

    public boolean validate() throws CoreException {
        return this.gradleProjectValidator.validate();
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IPath settingsFolderProjectRelativePath = this.gradleProjectValidator.getSettingsFolder().getProjectRelativePath();
        IPath preferencesFileProjectRelativePath = this.gradleProjectValidator.getPreferencesFile().getProjectRelativePath();
        if (delta.getProjectRelativePath().equals((Object)settingsFolderProjectRelativePath)) {
            if (delta.getKind() == 1 || delta.getKind() == 2) {
                this.validate();
                return false;
            }
        } else if (delta.getProjectRelativePath().equals((Object)preferencesFileProjectRelativePath) && (delta.getKind() == 1 || delta.getKind() == 2 || delta.getKind() == 4)) {
            this.validate();
            return false;
        }
        return true;
    }

    private static final class GradleProjectValidator {
        private final IProject project;
        private final IFolder settingsFolder;
        private final IFile preferencesFile;

        private GradleProjectValidator(IProject project) {
            this.project = project;
            this.settingsFolder = project.getFolder(".settings");
            this.preferencesFile = project.getFile(".settings/gradle.prefs");
        }

        public IFolder getSettingsFolder() {
            return this.settingsFolder;
        }

        public IFile getPreferencesFile() {
            return this.preferencesFile;
        }

        public boolean validate() throws CoreException {
            GradleProjectMarker.INSTANCE.removeMarkerFromResourceRecursively((IResource)this.project);
            if (!this.settingsFolder.exists()) {
                String message = String.format("Missing Gradle project configuration folder: %s", this.settingsFolder.getProjectRelativePath());
                GradleProjectMarker.INSTANCE.addMarkerToResource((IResource)this.project, message);
                return false;
            }
            if (!this.preferencesFile.exists()) {
                String message = String.format("Missing Gradle project configuration file: %s", this.preferencesFile.getProjectRelativePath());
                GradleProjectMarker.INSTANCE.addMarkerToResource((IResource)this.project, message);
                return false;
            }
            try {
                CorePlugin.projectConfigurationManager().readProjectConfiguration(this.project);
            }
            catch (Exception e) {
                String message = String.format("Invalid Gradle project configuration file: %s", this.preferencesFile.getProjectRelativePath());
                GradleProjectMarker.INSTANCE.addMarkerToResource((IResource)this.preferencesFile, message);
                return false;
            }
            return true;
        }
    }
}

