/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts;

import java.net.URI;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.internal.hash.HashUtil;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;

public abstract class AbstractUriScriptSource
implements ScriptSource {
    private String className;

    public String getClassName() {
        if (this.className == null) {
            URI sourceUri = this.getResource().getLocation().getURI();
            String path = sourceUri.toString();
            this.className = this.classNameFromPath(path);
        }
        return this.className;
    }

    private String classNameFromPath(String path) {
        String name = StringUtils.substringBeforeLast(StringUtils.substringAfterLast(path, "/"), ".");
        StringBuilder className = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            className.append(Character.isJavaIdentifierPart(ch) ? ch : (char)'_');
        }
        if (!Character.isJavaIdentifierStart(className.charAt(0))) {
            className.insert(0, '_');
        }
        className.setLength(Math.min(className.length(), 30));
        className.append('_');
        className.append(HashUtil.createCompactMD5(path));
        return className.toString();
    }
}

