/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.wizard.project;

import com.google.common.base.Preconditions;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.buildship.ui.wizard.project.HelpContextIdProvider;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.wizard.Wizard;
import org.osgi.service.prefs.BackingStoreException;

public abstract class AbstractProjectWizard
extends Wizard
implements HelpContextIdProvider {
    private final String welcomePageEnabledPreferenceKey;
    private boolean finishGloballyEnabled;

    protected AbstractProjectWizard(String welcomePageEnabledPreferenceKey) {
        this.welcomePageEnabledPreferenceKey = (String)Preconditions.checkNotNull((Object)welcomePageEnabledPreferenceKey);
        this.finishGloballyEnabled = true;
    }

    public boolean isShowWelcomePage() {
        ConfigurationScope configurationScope = new ConfigurationScope();
        IEclipsePreferences node = configurationScope.getNode("org.eclipse.buildship.ui");
        return node.getBoolean(this.welcomePageEnabledPreferenceKey, true);
    }

    public void setWelcomePageEnabled(boolean enabled) {
        ConfigurationScope configurationScope = new ConfigurationScope();
        IEclipsePreferences node = configurationScope.getNode("org.eclipse.buildship.ui");
        node.putBoolean(this.welcomePageEnabledPreferenceKey, enabled);
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            throw new GradlePluginsRuntimeException((Exception)((Object)e));
        }
    }

    public boolean canFinish() {
        return super.canFinish() && this.finishGloballyEnabled;
    }

    public void setFinishGloballyEnabled(boolean finishGloballyEnabled) {
        this.finishGloballyEnabled = finishGloballyEnabled;
    }
}

