/*
 * Decompiled with CFR 0.152.
 */
package com.gradleware.tooling.toolingclient.internal;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.gradleware.tooling.toolingclient.BuildActionRequest;
import com.gradleware.tooling.toolingclient.BuildLaunchRequest;
import com.gradleware.tooling.toolingclient.LaunchableConfig;
import com.gradleware.tooling.toolingclient.LongRunningOperationPromise;
import com.gradleware.tooling.toolingclient.ModelRequest;
import com.gradleware.tooling.toolingclient.TestConfig;
import com.gradleware.tooling.toolingclient.TestLaunchRequest;
import com.gradleware.tooling.toolingclient.ToolingClient;
import com.gradleware.tooling.toolingclient.internal.DefaultBuildActionRequest;
import com.gradleware.tooling.toolingclient.internal.DefaultBuildLaunchRequest;
import com.gradleware.tooling.toolingclient.internal.DefaultModelRequest;
import com.gradleware.tooling.toolingclient.internal.DefaultTestLaunchRequest;
import com.gradleware.tooling.toolingclient.internal.ExecutableToolingClient;
import com.gradleware.tooling.toolingclient.internal.InspectableBuildActionRequest;
import com.gradleware.tooling.toolingclient.internal.InspectableBuildLaunchRequest;
import com.gradleware.tooling.toolingclient.internal.InspectableModelRequest;
import com.gradleware.tooling.toolingclient.internal.InspectableRequest;
import com.gradleware.tooling.toolingclient.internal.InspectableTestLaunchRequest;
import java.util.Map;
import org.gradle.internal.Factory;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildActionExecuter;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.LongRunningOperation;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.TestLauncher;
import org.gradle.tooling.events.ProgressListener;
import org.gradle.tooling.internal.consumer.ConnectorServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultToolingClient
extends ToolingClient
implements ExecutableToolingClient {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultToolingClient.class);
    private final Factory<GradleConnector> connectorFactory;
    private final Map<Integer, ProjectConnection> connections;

    public DefaultToolingClient() {
        this(DefaultGradleConnectorFactory.INSTANCE);
    }

    public DefaultToolingClient(Factory<GradleConnector> connectorFactory) {
        this.connectorFactory = connectorFactory;
        this.connections = Maps.newHashMap();
    }

    @Override
    public <T> ModelRequest<T> newModelRequest(Class<T> modelType) {
        Preconditions.checkNotNull(modelType);
        return new DefaultModelRequest<T>(this, modelType);
    }

    @Override
    public <T> BuildActionRequest<T> newBuildActionRequest(BuildAction<T> buildAction) {
        Preconditions.checkNotNull(buildAction);
        return new DefaultBuildActionRequest<T>(this, buildAction);
    }

    @Override
    public BuildLaunchRequest newBuildLaunchRequest(LaunchableConfig launchables) {
        Preconditions.checkNotNull((Object)launchables);
        return new DefaultBuildLaunchRequest(this, launchables);
    }

    @Override
    public TestLaunchRequest newTestLaunchRequest(TestConfig tests) {
        Preconditions.checkNotNull((Object)tests);
        return new DefaultTestLaunchRequest(this, tests);
    }

    @Override
    public <T> T executeAndWait(InspectableModelRequest<T> modelRequest) {
        ProjectConnection connection = this.getProjectConnection(modelRequest);
        ModelBuilder<T> operation = this.mapToModelBuilder(modelRequest, connection);
        return (T)operation.get();
    }

    @Override
    public <T> LongRunningOperationPromise<T> execute(InspectableModelRequest<T> modelRequest) {
        ProjectConnection connection = this.getProjectConnection(modelRequest);
        ModelBuilder<T> operation = this.mapToModelBuilder(modelRequest, connection);
        return LongRunningOperationPromise.forModelBuilder(operation);
    }

    @Override
    public <T> T executeAndWait(InspectableBuildActionRequest<T> buildActionRequest) {
        ProjectConnection connection = this.getProjectConnection(buildActionRequest);
        BuildActionExecuter<T> operation = this.mapToBuildActionExecuter(buildActionRequest, connection);
        return (T)operation.run();
    }

    @Override
    public <T> LongRunningOperationPromise<T> execute(InspectableBuildActionRequest<T> buildActionRequest) {
        ProjectConnection connection = this.getProjectConnection(buildActionRequest);
        BuildActionExecuter<T> operation = this.mapToBuildActionExecuter(buildActionRequest, connection);
        return LongRunningOperationPromise.forBuildActionExecuter(operation);
    }

    @Override
    public Void executeAndWait(InspectableBuildLaunchRequest buildLaunchRequest) {
        ProjectConnection connection = this.getProjectConnection(buildLaunchRequest);
        BuildLauncher operation = this.mapToBuildLauncher(buildLaunchRequest, connection);
        operation.run();
        return null;
    }

    @Override
    public LongRunningOperationPromise<Void> execute(InspectableBuildLaunchRequest buildLaunchRequest) {
        ProjectConnection connection = this.getProjectConnection(buildLaunchRequest);
        BuildLauncher operation = this.mapToBuildLauncher(buildLaunchRequest, connection);
        return LongRunningOperationPromise.forBuildLauncher(operation);
    }

    @Override
    public Void executeAndWait(InspectableTestLaunchRequest testLaunchRequest) {
        ProjectConnection connection = this.getProjectConnection(testLaunchRequest);
        TestLauncher operation = this.mapToTestLauncher(testLaunchRequest, connection);
        operation.run();
        return null;
    }

    @Override
    public LongRunningOperationPromise<Void> execute(InspectableTestLaunchRequest testLaunchRequest) {
        ProjectConnection connection = this.getProjectConnection(testLaunchRequest);
        TestLauncher operation = this.mapToTestLauncher(testLaunchRequest, connection);
        return LongRunningOperationPromise.forTestLauncher(operation);
    }

    private ProjectConnection getProjectConnection(InspectableRequest<?> request) {
        Preconditions.checkNotNull(request);
        return this.getOrCreateProjectConnection(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectConnection getOrCreateProjectConnection(InspectableRequest<?> modelRequest) {
        ProjectConnection connection;
        int connectionKey = this.calculateConnectionKey(modelRequest);
        Map<Integer, ProjectConnection> map = this.connections;
        synchronized (map) {
            if (!this.connections.containsKey(connectionKey)) {
                connection = this.openConnection(modelRequest);
                this.connections.put(connectionKey, connection);
            } else {
                connection = this.connections.get(connectionKey);
            }
        }
        return connection;
    }

    private int calculateConnectionKey(InspectableRequest<?> modelRequest) {
        return Objects.hashCode((Object[])new Object[]{modelRequest.getProjectDir(), modelRequest.getGradleUserHomeDir(), modelRequest.getGradleDistribution()});
    }

    private ProjectConnection openConnection(InspectableRequest<?> modelRequest) {
        GradleConnector connector = (GradleConnector)this.connectorFactory.create();
        connector.forProjectDirectory(modelRequest.getProjectDir());
        connector.useGradleUserHomeDir(modelRequest.getGradleUserHomeDir());
        modelRequest.getGradleDistribution().apply(connector);
        return connector.connect();
    }

    private <T> ModelBuilder<T> mapToModelBuilder(InspectableModelRequest<T> modelRequest, ProjectConnection connection) {
        ModelBuilder modelBuilder = connection.model(modelRequest.getModelType());
        modelBuilder.forTasks(modelRequest.getTasks());
        return this.mapToLongRunningOperation(modelRequest, modelBuilder);
    }

    private <T> BuildActionExecuter<T> mapToBuildActionExecuter(InspectableBuildActionRequest<T> buildActionRequest, ProjectConnection connection) {
        BuildActionExecuter buildActionExecuter = connection.action(buildActionRequest.getBuildAction());
        return this.mapToLongRunningOperation(buildActionRequest, buildActionExecuter);
    }

    private BuildLauncher mapToBuildLauncher(InspectableBuildLaunchRequest buildLaunchRequest, ProjectConnection connection) {
        BuildLauncher buildLauncher = connection.newBuild();
        buildLaunchRequest.getLaunchables().apply(buildLauncher);
        return this.mapToLongRunningOperation(buildLaunchRequest, buildLauncher);
    }

    private TestLauncher mapToTestLauncher(InspectableTestLaunchRequest testLaunchRequest, ProjectConnection connection) {
        TestLauncher testLauncher = connection.newTestLauncher();
        testLaunchRequest.getTests().apply(testLauncher);
        return this.mapToLongRunningOperation(testLaunchRequest, testLauncher);
    }

    private <T extends LongRunningOperation> T mapToLongRunningOperation(InspectableRequest<?> request, T operation) {
        operation.setColorOutput(request.isColorOutput()).setStandardOutput(request.getStandardOutput()).setStandardError(request.getStandardError()).setStandardInput(request.getStandardInput()).setJavaHome(request.getJavaHomeDir()).setJvmArguments(request.getJvmArguments()).withArguments(request.getArguments()).withCancellationToken(request.getCancellationToken());
        for (org.gradle.tooling.ProgressListener progressListener : request.getProgressListeners()) {
            operation.addProgressListener(progressListener);
        }
        for (org.gradle.tooling.ProgressListener progressListener : request.getTypedProgressListeners()) {
            operation.addProgressListener((ProgressListener)progressListener);
        }
        return operation;
    }

    @Override
    public void stop(ToolingClient.CleanUpStrategy strategy) {
        switch (strategy) {
            case FORCEFULLY: {
                throw new UnsupportedOperationException(String.format("Cleanup strategy %s is currently not supported.", new Object[]{ToolingClient.CleanUpStrategy.FORCEFULLY}));
            }
            case GRACEFULLY: {
                this.closeConnections();
                this.expireDaemons();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnections() {
        Map<Integer, ProjectConnection> map = this.connections;
        synchronized (map) {
            for (ProjectConnection connection : this.connections.values()) {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    LOG.error("Error closing the connection: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void expireDaemons() {
        ConnectorServices.reset();
    }

    private static enum DefaultGradleConnectorFactory implements Factory<GradleConnector>
    {
        INSTANCE;


        public GradleConnector create() {
            return GradleConnector.newConnector();
        }
    }
}

