/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.util.logging;

import org.eclipse.buildship.core.Logger;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public final class EclipseLogger
implements Logger {
    private final ILog log;
    private final String pluginId;
    private final boolean isDebugging;

    public EclipseLogger(ILog log, String pluginId, boolean isDebugging) {
        this.log = log;
        this.pluginId = pluginId;
        this.isDebugging = isDebugging;
    }

    @Override
    public void info(String message) {
        if (this.isDebugging) {
            this.log.log((IStatus)new Status(1, this.pluginId, message));
        }
    }

    @Override
    public void info(String message, Throwable t) {
        if (this.isDebugging) {
            this.log.log((IStatus)new Status(1, this.pluginId, message, t));
        }
    }

    @Override
    public void warn(String message) {
        this.log.log((IStatus)new Status(2, this.pluginId, message));
    }

    @Override
    public void warn(String message, Throwable t) {
        this.log.log((IStatus)new Status(2, this.pluginId, message, t));
    }

    @Override
    public void error(String message) {
        this.log.log((IStatus)new Status(4, this.pluginId, message));
    }

    @Override
    public void error(String message, Throwable t) {
        this.log.log((IStatus)new Status(4, this.pluginId, message, t));
    }
}

