/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Sets;
import com.gradleware.tooling.toolingmodel.OmniEclipseLinkedResource;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.buildship.core.util.file.FileUtils;
import org.eclipse.buildship.core.workspace.internal.PersistentUpdater;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

final class LinkedResourcesUpdater
extends PersistentUpdater {
    private final IProject project;
    private final Map<String, OmniEclipseLinkedResource> linkedResources;

    private LinkedResourcesUpdater(IProject project, List<OmniEclipseLinkedResource> linkedResources) {
        super(project, "linkedResources");
        this.project = (IProject)Preconditions.checkNotNull((Object)project);
        this.linkedResources = FluentIterable.from(linkedResources).filter((Predicate)new LinkedResourcesWithValidLocation()).uniqueIndex((Function)new Function<OmniEclipseLinkedResource, String>(){

            public String apply(OmniEclipseLinkedResource resource) {
                return resource.getLocation();
            }
        });
    }

    private void updateLinkedResources(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        this.removeOutdatedLinkedResources(progress.newChild(1));
        this.createLinkedResources(progress.newChild(1));
    }

    private void removeOutdatedLinkedResources(SubMonitor progress) throws CoreException {
        Collection<String> resourceNames = this.getKnownItems();
        progress.setWorkRemaining(resourceNames.size());
        for (String resourceName : resourceNames) {
            SubMonitor childProgress = progress.newChild(1);
            IFolder folder = this.project.getFolder(resourceName);
            if (!this.shouldDelete(folder)) continue;
            folder.delete(false, (IProgressMonitor)childProgress);
        }
    }

    private boolean shouldDelete(IFolder folder) {
        return this.linkedWithValidLocation(folder) && !this.partOfCurrentGradleModel(folder);
    }

    private boolean linkedWithValidLocation(IFolder folder) {
        return folder.exists() && folder.isLinked() && folder.getLocation() != null;
    }

    private boolean partOfCurrentGradleModel(IFolder folder) {
        return this.linkedResources.containsKey(folder.getLocation().toString());
    }

    private void createLinkedResources(SubMonitor progress) throws CoreException {
        progress.setWorkRemaining(this.linkedResources.size());
        HashSet resourceNames = Sets.newHashSet();
        for (OmniEclipseLinkedResource linkedResource : this.linkedResources.values()) {
            SubMonitor childProgress = progress.newChild(1);
            IFolder linkedResourceFolder = this.createLinkedResourceFolder(linkedResource.getName(), linkedResource, childProgress);
            resourceNames.add(this.projectRelativePath(linkedResourceFolder));
        }
        this.setKnownItems(resourceNames);
    }

    private IFolder createLinkedResourceFolder(String name, OmniEclipseLinkedResource linkedResource, SubMonitor progress) throws CoreException {
        IFolder folder = this.project.getFolder(name);
        Path resourcePath = new Path(linkedResource.getLocation());
        FileUtils.ensureParentFolderHierarchyExists(folder);
        folder.createLink((IPath)resourcePath, 400, (IProgressMonitor)progress);
        return folder;
    }

    private String projectRelativePath(IFolder folder) {
        return folder.getFullPath().makeRelativeTo(this.project.getFullPath()).toPortableString();
    }

    public static void update(IProject project, List<OmniEclipseLinkedResource> linkedResources, IProgressMonitor monitor) throws CoreException {
        LinkedResourcesUpdater updater = new LinkedResourcesUpdater(project, linkedResources);
        updater.updateLinkedResources(monitor);
    }

    private static final class LinkedResourcesWithValidLocation
    implements Predicate<OmniEclipseLinkedResource> {
        private static final String LINKED_RESOURCE_TYPE_FOLDER = "2";

        private LinkedResourcesWithValidLocation() {
        }

        public boolean apply(OmniEclipseLinkedResource linkedResource) {
            return linkedResource.getLocation() != null && linkedResource.getType().equals(LINKED_RESOURCE_TYPE_FOLDER);
        }
    }
}

