/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.gradleware.tooling.toolingmodel.OmniEclipseProject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.util.file.RelativePathUtils;
import org.eclipse.buildship.core.workspace.internal.PersistentModelBuilder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

final class SubprojectMarkerUpdater {
    private final IProject project;
    private final OmniEclipseProject gradleProject;

    private SubprojectMarkerUpdater(IProject project, OmniEclipseProject gradleProject) {
        this.project = (IProject)Preconditions.checkNotNull((Object)project);
        this.gradleProject = (OmniEclipseProject)Preconditions.checkNotNull((Object)gradleProject);
    }

    public void update(PersistentModelBuilder persistentModel, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        try {
            List<IPath> subfolders = this.getNestedSubProjectFolderPaths(progress.newChild(1));
            persistentModel.subprojectPaths(subfolders);
        }
        catch (Exception e) {
            String message = String.format("Could not update sub-project markers on project %s.", this.project.getName());
            throw new GradlePluginsRuntimeException(message, e);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private List<IPath> getNestedSubProjectFolderPaths(SubMonitor progress) {
        ArrayList subfolderPaths = Lists.newArrayList();
        IPath parentPath = this.project.getLocation();
        for (OmniEclipseProject child : this.gradleProject.getChildren()) {
            IPath childPath = Path.fromOSString((String)child.getProjectDirectory().getPath());
            if (!parentPath.isPrefixOf(childPath)) continue;
            IPath relativePath = RelativePathUtils.getRelativePath(parentPath, childPath);
            subfolderPaths.add(relativePath);
        }
        return subfolderPaths;
    }

    public static void update(IProject workspaceProject, OmniEclipseProject gradleProject, PersistentModelBuilder persistentModel, IProgressMonitor monitor) {
        new SubprojectMarkerUpdater(workspaceProject, gradleProject).update(persistentModel, monitor);
    }
}

