/*
 * Decompiled with CFR 0.152.
 */
package com.gradleware.tooling.toolingmodel.repository.internal;

import com.google.common.collect.ImmutableSortedSet;
import com.gradleware.tooling.toolingmodel.OmniTaskSelector;
import com.gradleware.tooling.toolingmodel.Path;
import com.gradleware.tooling.toolingmodel.util.Maybe;
import java.util.SortedSet;
import org.gradle.tooling.model.TaskSelector;

public final class DefaultOmniTaskSelector
implements OmniTaskSelector {
    private String name;
    private String description;
    private Path projectPath;
    private boolean isPublic;
    private Maybe<String> group;
    private ImmutableSortedSet<Path> selectedTaskPaths;

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Path getProjectPath() {
        return this.projectPath;
    }

    public void setProjectPath(Path projectPath) {
        this.projectPath = projectPath;
    }

    @Override
    public boolean isPublic() {
        return this.isPublic;
    }

    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    @Override
    public Maybe<String> getGroup() {
        return this.group;
    }

    public void setGroup(Maybe<String> group) {
        this.group = group;
    }

    public ImmutableSortedSet<Path> getSelectedTaskPaths() {
        return this.selectedTaskPaths;
    }

    public void setSelectedTaskPaths(SortedSet<Path> selectedTaskPaths) {
        this.selectedTaskPaths = ImmutableSortedSet.copyOfSorted(selectedTaskPaths);
    }

    public static DefaultOmniTaskSelector from(TaskSelector selector, Path projectPath) {
        DefaultOmniTaskSelector taskSelector = new DefaultOmniTaskSelector();
        taskSelector.setName(selector.getName());
        taskSelector.setDescription(selector.getDescription());
        taskSelector.setProjectPath(projectPath);
        taskSelector.setGroup(Maybe.absent());
        DefaultOmniTaskSelector.setIsPublic(taskSelector, selector);
        taskSelector.setSelectedTaskPaths((SortedSet<Path>)ImmutableSortedSet.of());
        return taskSelector;
    }

    public static DefaultOmniTaskSelector from(String name, String description, Path projectPath, boolean isPublic, Maybe<String> group, SortedSet<Path> selectedTaskPaths) {
        DefaultOmniTaskSelector taskSelector = new DefaultOmniTaskSelector();
        taskSelector.setName(name);
        taskSelector.setDescription(description);
        taskSelector.setProjectPath(projectPath);
        taskSelector.setPublic(isPublic);
        taskSelector.setGroup(group);
        taskSelector.setSelectedTaskPaths(selectedTaskPaths);
        return taskSelector;
    }

    private static void setIsPublic(DefaultOmniTaskSelector gradleTaskSelector, TaskSelector taskSelector) {
        try {
            boolean isPublic = taskSelector.isPublic();
            gradleTaskSelector.setPublic(isPublic);
        }
        catch (Exception ignore) {
            gradleTaskSelector.setPublic(true);
        }
    }
}

