/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.launch;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.gradleware.tooling.toolingmodel.repository.TransientRequestAttributes;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.configuration.RunConfiguration;
import org.eclipse.buildship.core.console.ProcessDescription;
import org.eclipse.buildship.core.console.ProcessStreams;
import org.eclipse.buildship.core.launch.internal.BuildExecutionParticipants;
import org.eclipse.buildship.core.launch.internal.DefaultExecuteLaunchRequestEvent;
import org.eclipse.buildship.core.util.progress.DelegatingProgressListener;
import org.eclipse.buildship.core.util.progress.ToolingApiJob;
import org.eclipse.buildship.core.workspace.GradleBuild;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.gradle.tooling.LongRunningOperation;

public abstract class BaseLaunchRequestJob<T extends LongRunningOperation>
extends ToolingApiJob {
    protected BaseLaunchRequestJob(String name, boolean notifyUserAboutBuildFailures) {
        super(name, notifyUserAboutBuildFailures);
    }

    @Override
    protected final void runToolingApiJob(IProgressMonitor monitor) throws Exception {
        BuildExecutionParticipants.activateParticipantPlugins();
        monitor.beginTask(this.getJobTaskName(), -1);
        ProcessDescription processDescription = this.createProcessDescription();
        ProcessStreams processStreams = CorePlugin.processStreamsProvider().createProcessStreams(processDescription);
        RunConfiguration runConfig = this.getRunConfig();
        ImmutableList listeners = ImmutableList.of((Object)DelegatingProgressListener.withFullOutput(monitor));
        TransientRequestAttributes transientAttributes = new TransientRequestAttributes(false, processStreams.getOutput(), processStreams.getError(), processStreams.getInput(), (List)listeners, Collections.emptyList(), this.getToken());
        OutputStreamWriter configWriter = new OutputStreamWriter(processStreams.getConfiguration());
        GradleBuild gradleBuild = CorePlugin.gradleWorkspaceManager().getGradleBuild(runConfig.getBuildConfiguration());
        T launcher = this.createLaunch(gradleBuild, runConfig, transientAttributes, configWriter, processDescription);
        this.writeExtraConfigInfo(configWriter);
        configWriter.write(10);
        configWriter.flush();
        DefaultExecuteLaunchRequestEvent event = new DefaultExecuteLaunchRequestEvent(processDescription, (LongRunningOperation)launcher);
        CorePlugin.listenerRegistry().dispatch(event);
        this.executeLaunch(launcher);
    }

    protected abstract String getJobTaskName();

    protected abstract RunConfiguration getRunConfig();

    protected abstract ProcessDescription createProcessDescription();

    protected abstract T createLaunch(GradleBuild var1, RunConfiguration var2, TransientRequestAttributes var3, Writer var4, ProcessDescription var5);

    protected abstract void executeLaunch(T var1);

    protected abstract void writeExtraConfigInfo(OutputStreamWriter var1) throws IOException;

    protected static abstract class BaseProcessDescription
    implements ProcessDescription {
        private final String name;
        private final Job job;
        private final RunConfiguration runConfig;

        protected BaseProcessDescription(String name, Job job, RunConfiguration runConfig) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            this.job = (Job)Preconditions.checkNotNull((Object)job);
            this.runConfig = (RunConfiguration)Preconditions.checkNotNull((Object)runConfig);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Job getJob() {
            return this.job;
        }

        @Override
        public RunConfiguration getRunConfig() {
            return this.runConfig;
        }

        public boolean equals(Object obj) {
            if (obj instanceof BaseProcessDescription) {
                BaseProcessDescription that = (BaseProcessDescription)obj;
                return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.job, (Object)that.job) && Objects.equal((Object)this.runConfig, (Object)that.runConfig);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.name, this.job, this.runConfig});
        }
    }
}

