/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.util.configuration;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.gradleware.tooling.toolingclient.GradleDistribution;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.configuration.WorkspaceConfiguration;

@Deprecated
public final class FixedRequestAttributesBuilder {
    private final File projectDir;
    private File gradleUserHome = null;
    private GradleDistribution gradleDistribution = GradleDistribution.fromBuild();
    private File javaHome = null;
    private final List<String> jvmArguments = Lists.newArrayList();
    private final List<String> arguments = Lists.newArrayList();
    private boolean isOfflineMode = false;
    private boolean isBuildScansEnabled = false;

    private FixedRequestAttributesBuilder(File projectDir) {
        this.projectDir = (File)Preconditions.checkNotNull((Object)projectDir);
    }

    public FixedRequestAttributesBuilder gradleUserHome(File gradleUserHome) {
        this.gradleUserHome = gradleUserHome;
        return this;
    }

    public FixedRequestAttributesBuilder gradleDistribution(GradleDistribution gradleDistribution) {
        this.gradleDistribution = gradleDistribution == null ? GradleDistribution.fromBuild() : gradleDistribution;
        return this;
    }

    public FixedRequestAttributesBuilder javaHome(File javaHome) {
        this.javaHome = javaHome;
        return this;
    }

    public FixedRequestAttributesBuilder jvmArguments(List<String> jvmArguments) {
        this.jvmArguments.addAll(jvmArguments);
        return this;
    }

    public FixedRequestAttributesBuilder arguments(List<String> arguments) {
        this.arguments.addAll(arguments);
        return this;
    }

    public FixedRequestAttributesBuilder offlineMode(boolean isOfflineMode) {
        this.isOfflineMode = isOfflineMode;
        return this;
    }

    public FixedRequestAttributesBuilder buildScansEnabled(boolean isBuildScansEnabled) {
        this.isBuildScansEnabled = isBuildScansEnabled;
        return this;
    }

    public FixedRequestAttributes build() {
        ArrayList jvmArgs = Lists.newArrayList(this.jvmArguments);
        ArrayList args = Lists.newArrayList(this.arguments);
        if (this.isBuildScansEnabled) {
            jvmArgs.add("-Dscans");
        }
        if (this.isOfflineMode) {
            args.add("--offline");
        }
        return new FixedRequestAttributes(this.projectDir, this.gradleUserHome, this.gradleDistribution, this.javaHome, (List)jvmArgs, (List)args);
    }

    public static FixedRequestAttributesBuilder fromEmptySettings(File projectDir) {
        return new FixedRequestAttributesBuilder(projectDir);
    }

    public static FixedRequestAttributesBuilder fromWorkspaceSettings(File projectDir) {
        WorkspaceConfiguration configuration = CorePlugin.configurationManager().loadWorkspaceConfiguration();
        return FixedRequestAttributesBuilder.fromEmptySettings(projectDir).gradleUserHome(configuration.getGradleUserHome()).offlineMode(configuration.isOffline()).buildScansEnabled(configuration.isBuildScansEnabled()).arguments(CorePlugin.invocationCustomizer().getExtraArguments());
    }
}

