/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.operation;

import java.util.concurrent.TimeUnit;
import org.eclipse.buildship.core.internal.operation.ToolingApiOperation;
import org.eclipse.buildship.core.internal.operation.ToolingApiOperationManager;
import org.eclipse.buildship.core.internal.operation.ToolingApiStatus;
import org.eclipse.buildship.core.internal.util.progress.RateLimitingProgressMonitor;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.GradleConnector;

public final class DefaultToolingApiOperationManager
implements ToolingApiOperationManager {
    @Override
    public void run(ToolingApiOperation runnable, IProgressMonitor monitor) throws CoreException {
        this.run(runnable, GradleConnector.newCancellationTokenSource(), monitor);
    }

    @Override
    public void run(ToolingApiOperation runnable, CancellationTokenSource tokenSource, IProgressMonitor monitor) throws CoreException {
        RateLimitingProgressMonitor efficientMonitor = new RateLimitingProgressMonitor(monitor, 500L, TimeUnit.MILLISECONDS);
        ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)new WorkspaceRunnableAdapter(runnable, tokenSource), runnable.getRule(), 0, (IProgressMonitor)efficientMonitor);
    }

    private static class WorkspaceRunnableAdapter
    implements IWorkspaceRunnable {
        private final ToolingApiOperation runnable;
        private final CancellationTokenSource tokenSource;

        private WorkspaceRunnableAdapter(ToolingApiOperation runnable, CancellationTokenSource tokenSource) {
            this.runnable = runnable;
            this.tokenSource = tokenSource;
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            try {
                this.runnable.runInToolingApi(this.tokenSource, monitor);
            }
            catch (Exception e) {
                throw new CoreException((IStatus)ToolingApiStatus.from(this.runnable.getName(), e));
            }
        }
    }
}

