/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.util.widget;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.io.File;
import java.util.List;
import org.eclipse.buildship.core.internal.i18n.CoreMessages;
import org.eclipse.buildship.ui.internal.i18n.UiMessages;
import org.eclipse.buildship.ui.internal.launch.LaunchMessages;
import org.eclipse.buildship.ui.internal.util.file.DirectoryDialogSelectionListener;
import org.eclipse.buildship.ui.internal.util.font.FontUtils;
import org.eclipse.buildship.ui.internal.util.widget.HoverText;
import org.eclipse.buildship.ui.internal.util.widget.UiBuilder;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public final class AdvancedOptionsGroup
extends Group {
    private final Font defaultFont;
    private final UiBuilder.UiBuilderFactory builderFactory;
    private Text gradleUserHomeText;
    private Button gradleUserHomeBrowseButton;
    private Label gradleUserHomeWarningLabel;
    private Text javaHomeText;
    private Button javaHomeBrowseButton;
    private Label javaHomeWarningLabel;
    private Text argumentsText;
    private Text jvmArgumentsText;

    public AdvancedOptionsGroup(Composite parent, boolean variableSelector) {
        super(parent, 0);
        this.setText(CoreMessages.Preference_Label_AdvancedOptions);
        this.defaultFont = FontUtils.getDefaultDialogFont();
        this.builderFactory = new UiBuilder.UiBuilderFactory(this.defaultFont);
        this.setLayoutData(new GridData(4, 128, true, false));
        this.setLayout((Layout)new GridLayout(4, false));
        this.builderFactory.newLabel((Composite)this).alignLeft().text(CoreMessages.Preference_Label_Gradle_User_Home);
        this.gradleUserHomeText = this.builderFactory.newText((Composite)this).alignFillHorizontal().control();
        this.gradleUserHomeBrowseButton = this.builderFactory.newButton((Composite)this).alignLeft().text(UiMessages.Button_Label_Browse).control();
        this.gradleUserHomeWarningLabel = this.builderFactory.newLabel((Composite)this).alignLeft().control();
        this.gradleUserHomeWarningLabel.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK"));
        HoverText.createAndAttach((Control)this.gradleUserHomeWarningLabel, NLS.bind((String)CoreMessages.WarningMessage_Using_0_NonPortable, (Object)"Gradle user home"));
        this.builderFactory.newLabel((Composite)this).alignLeft().text(CoreMessages.Preference_Label_Java_Home);
        this.javaHomeText = this.builderFactory.newText((Composite)this).alignFillHorizontal().control();
        this.javaHomeBrowseButton = this.builderFactory.newButton((Composite)this).alignLeft().text(UiMessages.Button_Label_Browse).control();
        this.javaHomeWarningLabel = this.builderFactory.newLabel((Composite)this).alignLeft().control();
        this.javaHomeWarningLabel.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK"));
        HoverText.createAndAttach((Control)this.gradleUserHomeWarningLabel, NLS.bind((String)CoreMessages.WarningMessage_Using_0_NonPortable, (Object)"Java home"));
        this.builderFactory.newLabel((Composite)this).alignLeft().text(CoreMessages.RunConfiguration_Label_Arguments);
        if (variableSelector) {
            this.argumentsText = this.createMultlineText((Composite)this);
            this.createVariablesSelectorButton((Composite)this, this.argumentsText);
        } else {
            this.argumentsText = this.builderFactory.newText((Composite)this).alignFillBoth(1).control();
            this.builderFactory.newLabel((Composite)this).control().setVisible(false);
        }
        this.builderFactory.newLabel((Composite)this).control().setVisible(false);
        this.builderFactory.newLabel((Composite)this).alignLeft().text(CoreMessages.RunConfiguration_Label_JvmArguments);
        if (variableSelector) {
            this.jvmArgumentsText = this.createMultlineText((Composite)this);
            this.createVariablesSelectorButton((Composite)this, this.jvmArgumentsText);
        } else {
            this.jvmArgumentsText = this.builderFactory.newText((Composite)this).alignFillBoth(1).control();
            this.builderFactory.newLabel((Composite)this).control().setVisible(false);
        }
        this.builderFactory.newLabel((Composite)this).control().setVisible(false);
        this.addListeners();
    }

    private void addListeners() {
        this.gradleUserHomeText.addModifyListener(l -> this.updateWarningVisibility());
        this.javaHomeText.addModifyListener(l -> this.updateWarningVisibility());
        this.gradleUserHomeBrowseButton.addSelectionListener((SelectionListener)new DirectoryDialogSelectionListener(this.getShell(), this.gradleUserHomeText, "Gradle user home"));
        this.javaHomeBrowseButton.addSelectionListener((SelectionListener)new DirectoryDialogSelectionListener(this.getShell(), this.javaHomeText, "Java home"));
    }

    private Text createMultlineText(Composite container) {
        Text textControl = new Text(container, 2626);
        GridData textLayoutData = new GridData(4, 128, true, false, 1, 1);
        textLayoutData.heightHint = 65;
        textControl.setLayoutData((Object)textLayoutData);
        return textControl;
    }

    private void createVariablesSelectorButton(Composite container, final Text target) {
        Composite buttonContainer = new Composite(container, 0);
        GridLayout buttonContainerLayout = new GridLayout(1, false);
        buttonContainerLayout.marginHeight = 1;
        buttonContainerLayout.marginWidth = 0;
        buttonContainer.setLayout((Layout)buttonContainerLayout);
        buttonContainer.setLayoutData((Object)new GridData(128));
        Button selectVariableButton = new Button(buttonContainer, 0);
        selectVariableButton.setText(LaunchMessages.Button_Label_SelectVariables);
        selectVariableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(AdvancedOptionsGroup.this.getShell());
                dialog.open();
                String variable = dialog.getVariableExpression();
                if (variable != null) {
                    target.insert(variable);
                }
            }
        });
    }

    public Text getGradleUserHomeText() {
        return this.gradleUserHomeText;
    }

    public Text getJavaHomeText() {
        return this.javaHomeText;
    }

    public Text getArgumentsText() {
        return this.argumentsText;
    }

    public Text getJvmArgumentsText() {
        return this.jvmArgumentsText;
    }

    protected void checkSubclass() {
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updateEnablement();
    }

    private void updateEnablement() {
        boolean groupEnabled = this.getEnabled();
        this.gradleUserHomeText.setEnabled(groupEnabled);
        this.gradleUserHomeBrowseButton.setEnabled(groupEnabled);
        this.javaHomeText.setEnabled(groupEnabled);
        this.javaHomeBrowseButton.setEnabled(groupEnabled);
        this.updateWarningVisibility();
    }

    private void updateWarningVisibility() {
        boolean layout = false;
        layout |= AdvancedOptionsGroup.updateWarningVisibility(this.getEnabled(), this.gradleUserHomeText, this.gradleUserHomeWarningLabel);
        if (layout |= AdvancedOptionsGroup.updateWarningVisibility(this.getEnabled(), this.javaHomeText, this.javaHomeWarningLabel)) {
            this.getShell().layout(new Control[]{this}, 4);
        }
    }

    private static boolean updateWarningVisibility(boolean enabled, Text text, Label warning) {
        boolean warningShouldBeVisible;
        boolean warningIsVisible = warning.getVisible();
        boolean bl = warningShouldBeVisible = enabled && !text.getText().isEmpty();
        if (warningIsVisible != warningShouldBeVisible) {
            warning.setVisible(warningShouldBeVisible);
            Object layoutData = warning.getLayoutData();
            if (layoutData instanceof GridData) {
                GridData gridData = (GridData)layoutData;
                gridData.widthHint = warningShouldBeVisible ? -1 : 0;
                return true;
            }
        }
        return false;
    }

    public File getGradleUserHome() {
        String gradleUserHomeString = this.gradleUserHomeText.getText();
        return gradleUserHomeString.isEmpty() ? null : new File(gradleUserHomeString);
    }

    public void setGradleUserHome(File gradleUserHome) {
        if (gradleUserHome == null) {
            this.gradleUserHomeText.setText("");
        } else {
            this.gradleUserHomeText.setText(gradleUserHome.getPath());
        }
    }

    public File getJavaHome() {
        String javaHomeString = this.javaHomeText.getText();
        return javaHomeString.isEmpty() ? null : new File(javaHomeString);
    }

    public void setJavaHome(File javaHome) {
        if (javaHome == null) {
            this.javaHomeText.setText("");
        } else {
            this.javaHomeText.setText(javaHome.getPath());
        }
    }

    public List<String> getArguments() {
        return Splitter.on((char)' ').omitEmptyStrings().splitToList((CharSequence)this.argumentsText.getText());
    }

    public void setArguments(List<String> arguments) {
        this.argumentsText.setText(Joiner.on((char)' ').join(arguments));
    }

    public List<String> getJvmArguments() {
        return Splitter.on((char)' ').omitEmptyStrings().splitToList((CharSequence)this.jvmArgumentsText.getText());
    }

    public void setJvmArguments(List<String> jvmArguments) {
        this.jvmArgumentsText.setText(Joiner.on((char)' ').join(jvmArguments));
    }

    public void dispose() {
        if (this.defaultFont != null && !this.defaultFont.isDisposed()) {
            this.defaultFont.dispose();
        }
        super.dispose();
    }
}

