/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.operation;

import org.eclipse.buildship.core.internal.operation.ToolingApiOperation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.gradle.tooling.CancellationToken;
import org.gradle.tooling.CancellationTokenSource;

public final class ToolingApiOperations {
    private ToolingApiOperations() {
    }

    public static ToolingApiOperation concat(final ToolingApiOperation op1, final ToolingApiOperation op2) {
        return new ToolingApiOperation(){

            @Override
            public String getName() {
                return op1.getName() + ", " + op2.getName();
            }

            @Override
            public void runInToolingApi(CancellationTokenSource tokenSource, IProgressMonitor monitor) throws Exception {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
                progress.setWorkRemaining(2);
                CancellationToken token = tokenSource.token();
                op1.runInToolingApi(tokenSource, (IProgressMonitor)progress.newChild(1));
                if (monitor.isCanceled() && token.isCancellationRequested()) {
                    throw new OperationCanceledException();
                }
                op2.runInToolingApi(tokenSource, (IProgressMonitor)progress.newChild(1));
            }

            @Override
            public ISchedulingRule getRule() {
                return new MultiRule(new ISchedulingRule[]{op1.getRule(), op2.getRule()});
            }
        };
    }
}

