/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.workspace;

import org.eclipse.buildship.core.ProjectContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.gradle.tooling.model.eclipse.EclipseProject;
import org.gradle.tooling.model.eclipse.EclipseSourceDirectory;

final class OutputLocationUpdater {
    OutputLocationUpdater() {
    }

    public static void update(ProjectContext projectContext, IJavaProject project, EclipseProject eclipseProject, IProgressMonitor monitor) throws CoreException {
        String outputLocation = eclipseProject.getOutputLocation().getPath();
        if (OutputLocationUpdater.sourceDirHasNestedOutputLocation((Iterable<? extends EclipseSourceDirectory>)eclipseProject.getSourceDirectories(), outputLocation)) {
            String newOutputLocation = outputLocation + "-default";
            projectContext.warning("One or more source directories specify output location nested in the default output. Default output changed from " + outputLocation + " to " + newOutputLocation + ".", null);
            outputLocation = newOutputLocation;
        }
        project.setOutputLocation(project.getPath().append(outputLocation), monitor);
    }

    private static boolean sourceDirHasNestedOutputLocation(Iterable<? extends EclipseSourceDirectory> sourceDirs, String outputLocation) {
        Path outputPath = new Path(outputLocation);
        for (EclipseSourceDirectory eclipseSourceDirectory : sourceDirs) {
            Path sourceDirPath;
            if (eclipseSourceDirectory.getOutput() == null || outputPath.equals((Object)(sourceDirPath = new Path(eclipseSourceDirectory.getOutput()))) || !outputPath.isPrefixOf((IPath)sourceDirPath)) continue;
            return true;
        }
        return false;
    }
}

