/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.perfo.design.service.perfoListener;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.SessionManagerListener;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.model.helpers.FunctionalChainExt;
import org.polarsys.capella.vp.perfo.design.service.perfoListener.PerfoChangePreCommitListener;
import org.polarsys.capella.vp.perfo.perfo.PerformanceCriteria;
import org.polarsys.capella.vp.perfo.services.PerformanceServices;

public class PerfoSessionListener
implements SessionManagerListener {
    Map<Session, PerfoChangePreCommitListener> sessionsPerfoPreCommitListener = new HashMap<Session, PerfoChangePreCommitListener>();

    public void notifyAddSession(Session newSession) {
        Collection viewpoints = newSession.getSelectedViewpoints(false);
        boolean viewpointSelected = false;
        for (Viewpoint viewpoint : viewpoints) {
            if (!viewpoint.getName().equals("Perfo_ID")) continue;
            viewpointSelected = true;
        }
        if (!viewpointSelected) {
            return;
        }
        PerfoChangePreCommitListener perfoListener = new PerfoChangePreCommitListener();
        newSession.getTransactionalEditingDomain().addResourceSetListener((ResourceSetListener)perfoListener);
        this.registerPreCommitListener(newSession, perfoListener);
        this.computePerfo(newSession);
    }

    public void notifyRemoveSession(Session removedSession) {
    }

    public void viewpointSelected(Viewpoint selectedSirius) {
        if (!selectedSirius.getName().equals("Perfo_ID")) {
            return;
        }
        Collection sessions = SessionManager.INSTANCE.getSessions();
        for (Session session : sessions) {
            PerfoChangePreCommitListener perfoListener = new PerfoChangePreCommitListener();
            TransactionalEditingDomain transDomain = session.getTransactionalEditingDomain();
            if (transDomain == null) continue;
            transDomain.addResourceSetListener((ResourceSetListener)perfoListener);
            this.registerPreCommitListener(session, perfoListener);
            this.computePerfo(session);
        }
    }

    public void viewpointDeselected(Viewpoint deselectedSirius) {
        if (!deselectedSirius.getName().equals("Price_ID")) {
            return;
        }
        Set<Map.Entry<Session, PerfoChangePreCommitListener>> setSessionsPerfoPreCommitListener = this.sessionsPerfoPreCommitListener.entrySet();
        for (Map.Entry<Session, PerfoChangePreCommitListener> e : setSessionsPerfoPreCommitListener) {
            TransactionalEditingDomain transDomain = e.getKey().getTransactionalEditingDomain();
            if (transDomain == null) continue;
            transDomain.removeResourceSetListener((ResourceSetListener)e.getValue());
        }
    }

    public void notify(Session updated, int notification) {
    }

    public void registerPreCommitListener(Session session, PerfoChangePreCommitListener preCommit) {
        this.sessionsPerfoPreCommitListener.put(session, preCommit);
    }

    public void computePerfo(final Session session) {
        TransactionalEditingDomain domain = session.getTransactionalEditingDomain();
        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

            protected void doExecute() {
                PerformanceServices performanceServices = new PerformanceServices();
                List physicalFunctionalChains = FunctionalChainExt.getAllFunctionalChains((BlockArchitecture)PerfoSessionListener.this.retrievesPhysicalArchitectureFromSession(session));
                List logicalFunctionalChains = FunctionalChainExt.getAllFunctionalChains((BlockArchitecture)PerfoSessionListener.this.retrievesLogicalArchitectureFromSession(session));
                physicalFunctionalChains.stream().forEach(functionalChain -> functionalChain.eContents().stream().filter(content -> content instanceof PerformanceCriteria).forEach(perfoObject -> performanceServices.checkPerformance(perfoObject, (EObject)functionalChain)));
                logicalFunctionalChains.stream().forEach(functionalChain -> functionalChain.eContents().stream().filter(content -> content instanceof PerformanceCriteria).forEach(perfoObject -> performanceServices.checkPerformance(perfoObject, (EObject)functionalChain)));
            }
        });
    }

    private PhysicalArchitecture retrievesPhysicalArchitectureFromSession(Session session) {
        Collection resources = session.getSemanticResources();
        ArrayList physicalAchitecture = new ArrayList();
        resources.stream().filter(CapellaResourceHelper::isCapellaResource).forEach(resource -> resource.getContents().stream().filter(Project.class::isInstance).forEach(content -> ((Project)content).getOwnedModelRoots().stream().filter(SystemEngineering.class::isInstance).forEach(modelRoot -> ((SystemEngineering)modelRoot).getOwnedArchitectures().stream().filter(PhysicalArchitecture.class::isInstance).forEach(physicalArchitecture -> physicalAchitecture.add((PhysicalArchitecture)physicalArchitecture)))));
        return (PhysicalArchitecture)physicalAchitecture.get(0);
    }

    private LogicalArchitecture retrievesLogicalArchitectureFromSession(Session session) {
        Collection resources = session.getSemanticResources();
        ArrayList logicalAchitecture = new ArrayList();
        resources.stream().filter(CapellaResourceHelper::isCapellaResource).forEach(resource -> resource.getContents().stream().filter(Project.class::isInstance).forEach(content -> ((Project)content).getOwnedModelRoots().stream().filter(SystemEngineering.class::isInstance).forEach(modelRoot -> ((SystemEngineering)modelRoot).getOwnedArchitectures().stream().filter(LogicalArchitecture.class::isInstance).forEach(logicalArchitecture -> logicalAchitecture.add((LogicalArchitecture)logicalArchitecture)))));
        return (LogicalArchitecture)logicalAchitecture.get(0);
    }
}

