/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.ui.importer.preferences;

import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.polarsys.capella.common.helpers.operations.LongRunningListenersRegistry;
import org.polarsys.capella.core.commands.preferences.service.AbstractDefaultPreferencePage;
import org.polarsys.capella.vp.requirements.importer.preferences.RequirementsPreferencesPlugin;

public class RequirementsPreferencePage
extends AbstractDefaultPreferencePage {
    public RequirementsPreferencePage() {
        this.setPreferenceStore(RequirementsPreferencesPlugin.getDefault().getPreferenceStore());
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return RequirementsPreferencesPlugin.getDefault().getPreferenceStore();
    }

    public boolean performOk() {
        boolean result = false;
        try {
            LongRunningListenersRegistry.getInstance().operationStarting(((Object)((Object)this)).getClass());
            result = super.performOk();
        }
        finally {
            LongRunningListenersRegistry.getInstance().operationEnded(((Object)((Object)this)).getClass());
        }
        return result;
    }

    protected void createFieldEditors() {
        super.createFieldEditors();
        Composite parentGroup = new Composite(this.getFieldEditorParent(), 0);
        parentGroup.setLayout((Layout)new GridLayout(1, false));
        Group grp = this.createGroup("Requirement's label", "Insert here an interpreted expression that will be evaluated to show the requirement's label", parentGroup);
        StringFieldEditor _delayFieldEditor = new StringFieldEditor("requirement.label.expression", "Expression", (Composite)grp);
        this.addField((FieldEditor)_delayFieldEditor);
        StringFieldEditor maxLenFieldEditor = new StringFieldEditor("requirement.label.max.len", "Length (put nothing to display full text):", (Composite)grp);
        maxLenFieldEditor.getTextControl((Composite)grp).addModifyListener((ModifyListener)new NumberFieldModifyListener((Control)maxLenFieldEditor.getTextControl((Composite)grp)));
        this.addField((FieldEditor)maxLenFieldEditor);
        Group grpValue = this.createGroup("Attribute Value's label", "Insert here the maximum length of an attribute value's label", parentGroup);
        StringFieldEditor maxValueLenFieldEditor = new StringFieldEditor("value.label.max.len", "Length (put nothing to display full text):", (Composite)grpValue);
        maxValueLenFieldEditor.getTextControl((Composite)grpValue).addModifyListener((ModifyListener)new NumberFieldModifyListener((Control)maxValueLenFieldEditor.getTextControl((Composite)grpValue)));
        this.addField((FieldEditor)maxValueLenFieldEditor);
        Group grpOther = this.createGroup("Other configuration items", "", parentGroup);
        BooleanFieldEditor forceDoorsRmfUsageBooleanEditor = new BooleanFieldEditor("requirement.label.doors.rmf", "Force DOORS RMF usage check while importing requirements", (Composite)grpOther);
        this.addField((FieldEditor)forceDoorsRmfUsageBooleanEditor);
    }

    protected String getPageTitle() {
        return "Requirements";
    }

    protected String getPageDescription() {
        return "Capella requirements preference page";
    }

    class NumberFieldModifyListener
    implements ModifyListener {
        ControlDecoration decorator;

        public NumberFieldModifyListener(Control control) {
            this.decorator = new ControlDecoration(control, 0x1000000);
            this.decorator.setDescriptionText("Not a valid number");
            Image image = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
            this.decorator.setImage(image);
            this.decorator.hide();
        }

        public void modifyText(ModifyEvent event) {
            String text = ((Text)event.getSource()).getText();
            if (!text.matches("\\d*")) {
                this.decorator.show();
                RequirementsPreferencePage.this.setValid(false);
            } else {
                this.decorator.hide();
                RequirementsPreferencePage.this.setValid(true);
            }
        }
    }
}

