/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.vp.requirements.model.helpers;

import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.emf.common.util.URI;
import org.polarsys.capella.vp.requirements.importer.extension.ReqImporterPreferencesUtil;

public class LabelHelper {
    private LabelHelper() {
    }

    public static String transformHTMLToText(String content) {
        return LabelHelper.transformHTMLToTextWithLineFeed(content).replace("\r\n", " ").replace("\n", " ").trim();
    }

    public static String transformHTMLToText(String content, String rootTag) {
        String result = LabelHelper.transformHTMLToTextWithLineFeed(content).replace("\r\n", " ").replace("\n", " ").trim();
        if (rootTag != null && LabelHelper.keepHtmlTags()) {
            return "<" + rootTag + ">" + result + "</" + rootTag + ">";
        }
        return result;
    }

    public static String transformHTMLToTextWithLineFeed(String content) {
        content = !LabelHelper.keepHtmlTags() ? content.replaceAll("<xhtml:br/>", " ").replaceAll("<[^>]*>", "").trim() : content.replaceAll("(?!</xhtml)(?!<xhtml)<[^>]*>", "").replace("xhtml:", "");
        content = URI.decode((String)content);
        content = StringEscapeUtils.unescapeHtml((String)content);
        return content;
    }

    public static boolean keepHtmlTags() {
        return (Boolean)ReqImporterPreferencesUtil.getValueForPreferenceKey((String)"keepXHTMLTags", Boolean.class);
    }
}

