/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.importer.transposer.bridge;

import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.polarsys.capella.vp.requirements.importer.transposer.bridge.ImageImporter;
import org.polarsys.capella.vp.requirements.importer.transposer.bridge.Messages;

public class ImageImportingDialog
extends TitleAreaDialog {
    private Text relativePathText;
    private ImageImporter imageImporter;
    private IProject currentProject;
    private String separator = System.getProperty("file.separator");

    protected ImageImportingDialog(Shell parentShell, ImageImporter imageImporter, IProject currentProject) {
        super(parentShell);
        this.imageImporter = imageImporter;
        this.currentProject = currentProject;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().margins(5, 5).applyTo(container);
        Composite importingModesComposite = new Composite(container, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)importingModesComposite);
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).margins(0, 0).applyTo(importingModesComposite);
        this.setUpRelPathUI(container, importingModesComposite);
        return container;
    }

    protected void setUpRelPathUI(final Composite container, Composite importingModesComposite) {
        Label relativePathTextChoice = new Label(importingModesComposite, 4);
        relativePathTextChoice.setText(Messages.ImageImportingDialog_RelativePathLabel);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)relativePathTextChoice);
        this.relativePathText = new Text(importingModesComposite, 2052);
        this.relativePathText.setText(String.valueOf(this.currentProject.getName()) + this.separator);
        this.relativePathText.addModifyListener(e -> {
            String currentProjectParentLocation = this.currentProject.getLocation().removeLastSegments(1).toString();
            Path currentProjectParentPath = Paths.get(currentProjectParentLocation, new String[0]);
            if (this.relativePathText.getText() == "" || !currentProjectParentPath.resolve(this.relativePathText.getText()).toFile().exists()) {
                this.setErrorMessage(Messages.ImageImportingDialog_RelativePathErrorMessage);
                this.disableFinish();
            } else {
                this.enableFinishForRelPath();
            }
        });
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.relativePathText);
        Button relativePathBrowseButton = new Button(importingModesComposite, 8);
        relativePathBrowseButton.setText("Browse...");
        relativePathBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(container.getShell());
                String currentProjectLocation = ImageImportingDialog.this.currentProject.getLocation().toString();
                String currentProjectParentLocation = ImageImportingDialog.this.currentProject.getLocation().removeLastSegments(1).toString();
                dialog.setFilterPath(currentProjectLocation);
                String result = dialog.open();
                if (result != null) {
                    URI resultPath = Paths.get(result, new String[0]).toUri();
                    URI currentProjectParentPath = Paths.get(currentProjectParentLocation, new String[0]).toUri();
                    if (resultPath.toString().startsWith(currentProjectParentPath.toString())) {
                        URI relativizedPath = currentProjectParentPath.relativize(resultPath);
                        ImageImportingDialog.this.relativePathText.setText(relativizedPath.getPath());
                    } else {
                        ImageImportingDialog.this.relativePathText.setText("");
                    }
                }
            }
        });
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)relativePathBrowseButton);
        this.setEnableRelativeImagePath(true);
    }

    protected void enableFinishForRelPath() {
        this.setErrorMessage(null);
        this.getButton(0).setEnabled(true);
        String path = this.relativePathText.getText();
        if (!path.endsWith("/") && !path.endsWith("\\")) {
            path = String.valueOf(path) + this.separator;
        }
        this.imageImporter.setRelPath(path);
    }

    protected void disableFinish() {
        this.getButton(0).setEnabled(false);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Point getInitialSize() {
        return new Point(700, 250);
    }

    public void create() {
        super.create();
        this.setTitle("Image importing parameters");
        this.setMessage(String.valueOf(Messages.ImageImportingDialog_DefaultMessage) + Messages.ImageImportingDialog_RelPathMessage, 0);
        this.getButton(0).setEnabled(true);
    }

    private void setEnableRelativeImagePath(boolean enable) {
        this.relativePathText.setEnabled(enable);
    }
}

