/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.importer.transposer.activities;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.api.IDiffPolicy;
import org.eclipse.emf.diffmerge.api.IMergePolicy;
import org.eclipse.emf.diffmerge.api.scopes.IEditableModelScope;
import org.eclipse.emf.diffmerge.bridge.api.IBridge;
import org.eclipse.emf.diffmerge.bridge.api.IBridgeTrace;
import org.eclipse.emf.diffmerge.bridge.api.incremental.IIncrementalBridgeExecution;
import org.eclipse.emf.diffmerge.bridge.interactive.util.ResourceUtil;
import org.eclipse.emf.diffmerge.bridge.traces.gen.bridgetraces.BridgetracesFactory;
import org.eclipse.emf.diffmerge.bridge.traces.gen.bridgetraces.Trace;
import org.eclipse.emf.diffmerge.diffdata.EComparison;
import org.eclipse.emf.diffmerge.impl.scopes.FragmentedModelScope;
import org.eclipse.emf.diffmerge.ui.specification.ext.ResourceScopeDefinition;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.reqif10.ReqIF10Package;
import org.eclipse.rmf.reqif10.ReqIFContent;
import org.eclipse.rmf.reqif10.datatypes.DatatypesPackage;
import org.eclipse.rmf.reqif10.serialization.ReqIF10ResourceFactoryImpl;
import org.eclipse.rmf.reqif10.xhtml.XhtmlPackage;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.ExecutionManagerRegistry;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.transition.common.activities.AbstractActivity;
import org.polarsys.capella.vp.requirements.importer.transposer.activities.Messages;
import org.polarsys.capella.vp.requirements.importer.transposer.activities.ReqIFJobSchedulingRule;
import org.polarsys.capella.vp.requirements.importer.transposer.bridge.ReqIFMapping;
import org.polarsys.capella.vp.requirements.importer.transposer.bridge.RequirementsVPBridge;
import org.polarsys.capella.vp.requirements.importer.transposer.policies.ReqIFImporterDiffPolicy;
import org.polarsys.capella.vp.requirements.importer.transposer.policies.ReqIFMergePolicy;
import org.polarsys.kitalpha.cadence.core.api.parameter.ActivityParameters;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class InitializeTransformation
extends AbstractActivity {
    public static String getId() {
        return InitializeTransformation.class.getCanonicalName();
    }

    protected IStatus _run(final ActivityParameters activityParams) {
        Job job = new Job("Load ReqIF resource"){

            public IStatus run(IProgressMonitor monitor) {
                return InitializeTransformation.this.initializeTransformation(activityParams);
            }
        };
        job.setRule((ISchedulingRule)ReqIFJobSchedulingRule.getInstance());
        job.setPriority(20);
        job.schedule();
        return Status.OK_STATUS;
    }

    protected IStatus initializeTransformation(ActivityParameters activityParams) {
        IContext context = (IContext)activityParams.getParameter("TransposerContext").getValue();
        IStatus loadSourceStatus = this.loadSourceScope(context);
        if (!this.checkStatus(loadSourceStatus)) {
            return loadSourceStatus;
        }
        IStatus loadTargetStatus = this.loadTransformationScope(context);
        if (!this.checkStatus(loadTargetStatus)) {
            return loadTargetStatus;
        }
        IEditableModelScope sourceScope = (IEditableModelScope)context.get((Object)"SOURCE_SCOPE");
        IEditableModelScope targetScope = (IEditableModelScope)context.get((Object)"TARGET_SCOPE");
        ReqIFMapping mapping = new ReqIFMapping(context);
        RequirementsVPBridge bridge = this.createBridge(sourceScope, targetScope, (IBridge<IEditableModelScope, IEditableModelScope>)mapping);
        Resource traceResource = this.getCreateResource(this.getTraceURI(this.getTransformationURI(targetScope)), this.getTransformationDomain(targetScope));
        IBridgeTrace existingTrace = this.getTrace(bridge, traceResource);
        IIncrementalBridgeExecution execution2 = bridge.executeOn(sourceScope, targetScope, null, existingTrace, true, (IProgressMonitor)new NullProgressMonitor());
        context.put((Object)"BRIDGE", (Object)bridge);
        context.put((Object)"TRACE_RESOURCE", (Object)traceResource);
        context.put((Object)"BRIDGE_EXECUTION", (Object)execution2);
        return Status.OK_STATUS;
    }

    protected TransactionalEditingDomain getTransformationDomain(IEditableModelScope definition) {
        return TransactionUtil.getEditingDomain((ResourceSet)((Resource)((FragmentedModelScope)definition).getRootResources().iterator().next()).getResourceSet());
    }

    protected URI getTransformationURI(IEditableModelScope definition) {
        return ((Resource)((FragmentedModelScope)definition).getRootResources().iterator().next()).getURI();
    }

    protected RequirementsVPBridge createBridge(IEditableModelScope sourceScope, IEditableModelScope targetScope, IBridge<IEditableModelScope, IEditableModelScope> bridge) {
        return new RequirementsVPBridge(sourceScope, targetScope, bridge, (IDiffPolicy)new ReqIFImporterDiffPolicy(), (IMergePolicy)new ReqIFMergePolicy(), null){

            @Override
            protected EMFDiffNode createDiffNode(EComparison comparison, EditingDomain domain) {
                EMFDiffNode diffNode = super.createDiffNode(comparison, domain);
                return diffNode;
            }
        };
    }

    protected URI getTraceURI(URI uri) {
        return uri.appendFileExtension("bridgetraces");
    }

    protected IStatus loadTransformationScope(IContext context) {
        BlockArchitecture target = (BlockArchitecture)context.get((Object)"TARGET_ELEMENT");
        EObject root = EcoreUtil.getRootContainer((EObject)target);
        ResourceScopeDefinition definition = new ResourceScopeDefinition(root.eResource(), InitializeTransformation.getId(), true);
        IEditableModelScope targetScope = definition.createScope(definition.getEntrypoint());
        context.put((Object)"TARGET_SCOPE", (Object)targetScope);
        return Status.OK_STATUS;
    }

    protected IStatus loadSourceScope(IContext context) {
        ExecutionManager manager = ExecutionManagerRegistry.getInstance().addNewManager();
        ResourceSet resourceSet = manager.getEditingDomain().getResourceSet();
        resourceSet.getPackageRegistry().put((Object)ReqIF10Package.eINSTANCE.getNsURI(), (Object)ReqIF10Package.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)XhtmlPackage.eINSTANCE.getNsURI(), (Object)XhtmlPackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)DatatypesPackage.eINSTANCE.getNsURI(), (Object)DatatypesPackage.eINSTANCE);
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("reqif", new ReqIF10ResourceFactoryImpl());
        URI uri = (URI)context.get((Object)"CONTEXT_MODEL");
        Resource resource = resourceSet.getResource(uri, true);
        List specifications = resource.getContents().stream().filter(ReqIF.class::isInstance).map(ReqIF.class::cast).map(ReqIF::getCoreContent).map(ReqIFContent::getSpecifications).flatMap(s -> s.stream()).collect(Collectors.toList());
        if (specifications.isEmpty()) {
            context.put((Object)"ReqIF model must have at least a module", (Object)false);
            return new Status(8, "org.polarsys.capella.vp.requirements.importer", Messages.ReqIfImport_NoModuleFoundPopup_Content);
        }
        context.put((Object)"ReqIF model must have at least a module", (Object)true);
        ResourceScopeDefinition definition = new ResourceScopeDefinition(resource, InitializeTransformation.getId(), false);
        IEditableModelScope sourceScope = definition.createScope(definition.getEntrypoint());
        context.put((Object)"SOURCE_SCOPE", (Object)sourceScope);
        return this.checkErrors((EList<Resource.Diagnostic>)resource.getErrors());
    }

    private IStatus checkErrors(EList<Resource.Diagnostic> errors) {
        if (errors == null || errors.isEmpty()) {
            return Status.OK_STATUS;
        }
        if (errors.size() == 1) {
            return new Status(4, "org.polarsys.capella.vp.requirements.importer", 0, ((Resource.Diagnostic)errors.get(0)).getMessage(), this.safeCast((Resource.Diagnostic)errors.get(0)));
        }
        MultiStatus statii = new MultiStatus("org.polarsys.capella.vp.requirements.importer", 0, "Errors while loading ReqIF file", null);
        for (Resource.Diagnostic diagnostic : errors) {
            statii.add((IStatus)new Status(4, "org.polarsys.capella.vp.requirements.importer", 0, diagnostic.getMessage(), this.safeCast(diagnostic)));
        }
        return statii;
    }

    private Throwable safeCast(Resource.Diagnostic diagnostic) {
        if (diagnostic instanceof Throwable) {
            return (Throwable)diagnostic;
        }
        return null;
    }

    protected IBridgeTrace getTrace(final RequirementsVPBridge bridge, final Resource traceResource) {
        EObject root;
        Trace trace = null;
        if (!traceResource.getContents().isEmpty() && (root = (EObject)traceResource.getAllContents().next()) instanceof IBridgeTrace) {
            trace = (IBridgeTrace)root;
        }
        if (trace == null) {
            trace = BridgetracesFactory.eINSTANCE.createTrace();
        }
        final Trace trace2 = trace;
        TransactionHelper.getExecutionManager((Resource)traceResource).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                if (traceResource.getContents().isEmpty()) {
                    traceResource.getContents().add((Object)trace2);
                }
                bridge.initializeTrace(trace2);
            }
        });
        return trace;
    }

    protected Resource getCreateResource(URI uri, TransactionalEditingDomain domain) {
        ResourceSet rs = domain.getResourceSet();
        Resource result = ResourceUtil.getCreateResourceForUri((URI)uri, (ResourceSet)rs);
        ResourceUtil.ensureLoaded((Resource)result);
        return result;
    }
}

