/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.ju.testcases;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.vp.requirements.importer.extension.AttributeSet;
import org.polarsys.capella.vp.requirements.importer.extension.AttributesProvider;
import org.polarsys.capella.vp.requirements.importer.extension.ReqImporterPreferencesUtil;
import org.polarsys.capella.vp.requirements.importer.preferences.RequirementsPreferencesPlugin;

public class ImportPreferencesTestCase
extends BasicTestCase {
    public static final String FILE_CONTENT = "Attribute1:true\nAttribute2:false\n";
    public static final String ATTRIBUTE1 = "Attribute1";
    public static final String ATTRIBUTE2 = "Attribute2";

    public void test() throws Exception {
        NullProgressMonitor npm = new NullProgressMonitor();
        ScopedPreferenceStore preferenceStore = (ScopedPreferenceStore)RequirementsPreferencesPlugin.getDefault().getPreferenceStore();
        IProject importPropertiesProject = ResourcesPlugin.getWorkspace().getRoot().getProject("ImportPropertiesProject");
        importPropertiesProject.create((IProgressMonitor)npm);
        importPropertiesProject.open((IProgressMonitor)npm);
        IFile workspaceFile = importPropertiesProject.getFile("WorkspaceFile.properties");
        ByteArrayInputStream workspacePropertiesFileContent = new ByteArrayInputStream(FILE_CONTENT.getBytes(StandardCharsets.UTF_8));
        workspaceFile.create((InputStream)workspacePropertiesFileContent, true, (IProgressMonitor)npm);
        File classicFile = File.createTempFile("ClassicFile", ".properties");
        classicFile.deleteOnExit();
        OutputStreamWriter osw = new OutputStreamWriter(new FileOutputStream(classicFile));
        osw.write(FILE_CONTENT);
        osw.close();
        ArrayList<URI> propertiesFileURIs = new ArrayList<URI>();
        propertiesFileURIs.add(URI.createPlatformResourceURI((String)workspaceFile.getFullPath().toString(), (boolean)true));
        propertiesFileURIs.add(URI.createFileURI((String)classicFile.getAbsolutePath()));
        String value = ReqImporterPreferencesUtil.serializePropertyFilesPreference(propertiesFileURIs);
        preferenceStore.setValue("requirement.properties.files", value);
        Collection selectedAttributes = null;
        AttributesProvider.invalidateModel();
        selectedAttributes = AttributesProvider.getInstance().getSelectedAttributeTypes();
        ImportPreferencesTestCase.assertTrue((boolean)selectedAttributes.containsAll(this.getDefaultContributedAttributes()));
        ImportPreferencesTestCase.assertTrue((boolean)selectedAttributes.containsAll(this.getMandatoryContributedAttributes()));
        ImportPreferencesTestCase.assertTrue((boolean)selectedAttributes.contains(ATTRIBUTE1));
        ImportPreferencesTestCase.assertFalse((boolean)selectedAttributes.contains(ATTRIBUTE2));
        preferenceStore.setValue(String.valueOf(workspaceFile.getName()) + "." + ATTRIBUTE2, true);
        AttributesProvider.invalidateModel();
        selectedAttributes = AttributesProvider.getInstance().getSelectedAttributeTypes();
        ImportPreferencesTestCase.assertTrue((boolean)selectedAttributes.containsAll(this.getDefaultContributedAttributes()));
        ImportPreferencesTestCase.assertTrue((boolean)selectedAttributes.containsAll(this.getMandatoryContributedAttributes()));
        ImportPreferencesTestCase.assertTrue((boolean)selectedAttributes.contains(ATTRIBUTE1));
        ImportPreferencesTestCase.assertFalse((boolean)selectedAttributes.contains(ATTRIBUTE2));
        preferenceStore.setValue(String.valueOf(classicFile.getName()) + "." + ATTRIBUTE2, true);
        AttributesProvider.invalidateModel();
        selectedAttributes = AttributesProvider.getInstance().getSelectedAttributeTypes();
        ImportPreferencesTestCase.assertTrue((boolean)selectedAttributes.containsAll(this.getDefaultContributedAttributes()));
        ImportPreferencesTestCase.assertTrue((boolean)selectedAttributes.containsAll(this.getMandatoryContributedAttributes()));
        ImportPreferencesTestCase.assertTrue((boolean)selectedAttributes.contains(ATTRIBUTE1));
        ImportPreferencesTestCase.assertTrue((boolean)selectedAttributes.contains(ATTRIBUTE2));
    }

    public List<String> getDefaultContributedAttributes() {
        List contributedCategories = ReqImporterPreferencesUtil.loadContributedCategories();
        ArrayList<String> result = new ArrayList<String>();
        for (AttributeSet category : contributedCategories) {
            for (AttributeSet attribute : category.getChildren()) {
                if (!attribute.defaultValue()) continue;
                result.add(attribute.getName());
            }
        }
        return result;
    }

    public List<String> getMandatoryContributedAttributes() {
        List contributedCategories = ReqImporterPreferencesUtil.loadContributedCategories();
        ArrayList<String> result = new ArrayList<String>();
        for (AttributeSet category : contributedCategories) {
            for (AttributeSet attribute : category.getChildren()) {
                if (!attribute.isMandatory()) continue;
                result.add(attribute.getName());
            }
        }
        return result;
    }
}

