/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.importer.transposer.bridge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.diffmerge.api.scopes.IEditableModelScope;
import org.eclipse.emf.diffmerge.api.scopes.IModelScope;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rmf.reqif10.AttributeDefinition;
import org.eclipse.rmf.reqif10.AttributeDefinitionBoolean;
import org.eclipse.rmf.reqif10.AttributeDefinitionDate;
import org.eclipse.rmf.reqif10.AttributeDefinitionEnumeration;
import org.eclipse.rmf.reqif10.AttributeDefinitionInteger;
import org.eclipse.rmf.reqif10.AttributeDefinitionReal;
import org.eclipse.rmf.reqif10.AttributeDefinitionString;
import org.eclipse.rmf.reqif10.AttributeDefinitionXHTML;
import org.eclipse.rmf.reqif10.AttributeValue;
import org.eclipse.rmf.reqif10.AttributeValueEnumeration;
import org.eclipse.rmf.reqif10.AttributeValueXHTML;
import org.eclipse.rmf.reqif10.DatatypeDefinition;
import org.eclipse.rmf.reqif10.DatatypeDefinitionEnumeration;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.reqif10.ReqIF10Package;
import org.eclipse.rmf.reqif10.SpecHierarchy;
import org.eclipse.rmf.reqif10.SpecObject;
import org.eclipse.rmf.reqif10.SpecRelation;
import org.eclipse.rmf.reqif10.SpecType;
import org.eclipse.rmf.reqif10.Specification;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.vp.requirements.CapellaRequirements.CapellaRequirementsFactory;
import org.polarsys.capella.vp.requirements.CapellaRequirements.CapellaTypesFolder;
import org.polarsys.capella.vp.requirements.importer.preferences.RequirementsPreferencesPlugin;
import org.polarsys.kitalpha.emde.model.ElementExtension;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;
import org.polarsys.kitalpha.vp.requirements.Requirements.TypesFolder;

public class ReqIFMappingQueries {
    public static BlockArchitecture getTargetBlockArchitecture(IContext context, IEditableModelScope scope) {
        BlockArchitecture srcBlock = (BlockArchitecture)context.get((Object)"TARGET_ELEMENT");
        BlockArchitecture tgtBlock = null;
        TreeIterator it = scope.getAllContents();
        while (it.hasNext()) {
            EObject next = (EObject)it.next();
            if (!(next instanceof ModelElement) || !((ModelElement)next).getId().equals(srcBlock.getId())) continue;
            tgtBlock = (BlockArchitecture)next;
            break;
        }
        return tgtBlock;
    }

    public static TypesFolder getTypesFolder(IContext context, IEditableModelScope scope) {
        BlockArchitecture block = ReqIFMappingQueries.getTargetBlockArchitecture(context, scope);
        if (block != null) {
            for (ElementExtension ext : block.getOwnedExtensions()) {
                if (!(ext instanceof TypesFolder)) continue;
                return (TypesFolder)ext;
            }
            CapellaTypesFolder folder = CapellaRequirementsFactory.eINSTANCE.createCapellaTypesFolder();
            folder.setReqIFLongName("Types Folder");
            folder.setReqIFIdentifier(ReqIFMappingQueries.getSourceModelId(context));
            block.getOwnedExtensions().add((Object)folder);
            return folder;
        }
        return null;
    }

    private static String getSourceModelId(IContext context) {
        EObject root;
        Object src = context.get((Object)"SOURCE_SCOPE");
        if (src instanceof IModelScope && (root = (EObject)((IModelScope)src).getContents().get(0)) instanceof ReqIF) {
            return ((ReqIF)root).getTheHeader().getIdentifier();
        }
        return null;
    }

    public static Collection<Specification> getAllSpecifications(IEditableModelScope scope) {
        ArrayList<Specification> specifications = new ArrayList<Specification>();
        for (Specification specification : ReqIFMappingQueries.getReqIFModelRoot(scope).getCoreContent().getSpecifications()) {
            specifications.add(specification);
        }
        return specifications;
    }

    public static Collection<SpecHierarchy> getAllFolders(IEditableModelScope scope) {
        ArrayList<SpecHierarchy> hierarchies = new ArrayList<SpecHierarchy>();
        for (EObject hierarchy : EObjectExt.getAll((EObject)ReqIFMappingQueries.getReqIFModelRoot(scope), (EClass)ReqIF10Package.Literals.SPEC_HIERARCHY)) {
            if (((SpecHierarchy)hierarchy).getChildren().isEmpty()) continue;
            hierarchies.add((SpecHierarchy)hierarchy);
        }
        return hierarchies;
    }

    public static Collection<SpecHierarchy> getAllRequirements(IEditableModelScope scope) {
        ArrayList<SpecHierarchy> hierarchies = new ArrayList<SpecHierarchy>();
        for (EObject hierarchy : EObjectExt.getAll((EObject)ReqIFMappingQueries.getReqIFModelRoot(scope), (EClass)ReqIF10Package.Literals.SPEC_HIERARCHY)) {
            if (!((SpecHierarchy)hierarchy).getChildren().isEmpty()) continue;
            hierarchies.add((SpecHierarchy)hierarchy);
        }
        return ReqIFMappingQueries.filter(hierarchies);
    }

    public static Collection<SpecRelation> getAllRelations(IEditableModelScope scope) {
        ArrayList<SpecRelation> specRelations = new ArrayList<SpecRelation>();
        for (EObject relation : EObjectExt.getAll((EObject)ReqIFMappingQueries.getReqIFModelRoot(scope), (EClass)ReqIF10Package.Literals.SPEC_RELATION)) {
            if (!ReqIFMappingQueries.relationCondition((EObject)ReqIFMappingQueries.getHierarchyFromObject(((SpecRelation)relation).getSource())) || !ReqIFMappingQueries.relationCondition((EObject)ReqIFMappingQueries.getHierarchyFromObject(((SpecRelation)relation).getTarget()))) continue;
            specRelations.add((SpecRelation)relation);
        }
        return specRelations;
    }

    public static Collection<SpecType> getAllTypes(IEditableModelScope scope) {
        ArrayList<SpecType> types = new ArrayList<SpecType>();
        for (SpecHierarchy folder : ReqIFMappingQueries.getAllFolders(scope)) {
            types.add((SpecType)folder.getObject().getType());
        }
        for (SpecHierarchy requirement : ReqIFMappingQueries.getAllRequirements(scope)) {
            types.add((SpecType)requirement.getObject().getType());
        }
        for (SpecRelation relation : ReqIFMappingQueries.getAllRelations(scope)) {
            types.add((SpecType)relation.getType());
        }
        for (Specification specification : ReqIFMappingQueries.getAllSpecifications(scope)) {
            types.add((SpecType)specification.getType());
        }
        return types;
    }

    public static Collection<DatatypeDefinition> getAllTypeDefinitions(IEditableModelScope scope) {
        ArrayList<DatatypeDefinition> typeDefinitions = new ArrayList<DatatypeDefinition>();
        for (SpecType type : ReqIFMappingQueries.getAllTypes(scope)) {
            for (AttributeDefinition definition : type.getSpecAttributes()) {
                try {
                    DatatypeDefinitionEnumeration def;
                    if (definition instanceof AttributeDefinitionEnumeration) {
                        def = ((AttributeDefinitionEnumeration)definition).getType();
                        if (typeDefinitions.contains(def)) continue;
                        typeDefinitions.add((DatatypeDefinition)def);
                        continue;
                    }
                    if (definition instanceof AttributeDefinitionXHTML) {
                        def = ((AttributeDefinitionXHTML)definition).getType();
                        if (typeDefinitions.contains(def)) continue;
                        typeDefinitions.add((DatatypeDefinition)def);
                        continue;
                    }
                    if (definition instanceof AttributeDefinitionBoolean) {
                        def = ((AttributeDefinitionBoolean)definition).getType();
                        if (typeDefinitions.contains(def)) continue;
                        typeDefinitions.add((DatatypeDefinition)def);
                        continue;
                    }
                    if (definition instanceof AttributeDefinitionDate) {
                        def = ((AttributeDefinitionDate)definition).getType();
                        if (typeDefinitions.contains(def)) continue;
                        typeDefinitions.add((DatatypeDefinition)def);
                        continue;
                    }
                    if (definition instanceof AttributeDefinitionInteger) {
                        def = ((AttributeDefinitionInteger)definition).getType();
                        if (typeDefinitions.contains(def)) continue;
                        typeDefinitions.add((DatatypeDefinition)def);
                        continue;
                    }
                    if (definition instanceof AttributeDefinitionReal) {
                        def = ((AttributeDefinitionReal)definition).getType();
                        if (typeDefinitions.contains(def)) continue;
                        typeDefinitions.add((DatatypeDefinition)def);
                        continue;
                    }
                    if (!(definition instanceof AttributeDefinitionString) || typeDefinitions.contains(def = ((AttributeDefinitionString)definition).getType())) continue;
                    typeDefinitions.add((DatatypeDefinition)def);
                }
                catch (Exception e) {
                    System.out.println("Can't read type of definition: " + definition.getLongName());
                }
            }
        }
        return typeDefinitions;
    }

    private static ReqIF getReqIFModelRoot(IEditableModelScope scope) {
        return (ReqIF)scope.getContents().get(0);
    }

    private static Collection<SpecHierarchy> filter(Collection<SpecHierarchy> collection) {
        Iterator<SpecHierarchy> it = collection.iterator();
        while (it.hasNext()) {
            SpecHierarchy object = it.next();
            if (ReqIFMappingQueries.condition((EObject)object)) continue;
            it.remove();
        }
        return collection;
    }

    private static boolean condition(EObject object) {
        if (object instanceof SpecHierarchy) {
            boolean foundIEPUID = false;
            boolean foundIEObjectType = false;
            SpecObject specObject = ((SpecHierarchy)object).getObject();
            for (AttributeValue attributeValue : specObject.getValues()) {
                if (attributeValue instanceof AttributeValueXHTML) {
                    if (!"IE PUID".equals(((AttributeValueXHTML)attributeValue).getDefinition().getLongName())) continue;
                    foundIEPUID = true;
                    continue;
                }
                if (!(attributeValue instanceof AttributeValueEnumeration) || !"IE Object Type".equals(((AttributeValueEnumeration)attributeValue).getDefinition().getLongName())) continue;
                foundIEObjectType = true;
            }
            Boolean forceDoorsRmfUsage = RequirementsPreferencesPlugin.getDefault().getPreferenceStore().getBoolean("requirement.label.doors.rmf");
            if (forceDoorsRmfUsage.booleanValue()) {
                return foundIEPUID && foundIEObjectType;
            }
        }
        return true;
    }

    private static boolean relationCondition(EObject object) {
        return ReqIFMappingQueries.condition(object);
    }

    public static SpecHierarchy getHierarchyFromObject(SpecObject object) {
        ReqIF rootEObject = (ReqIF)EcoreUtil.getRootContainer((EObject)object);
        for (EStructuralFeature.Setting ref : EcoreUtil.UsageCrossReferencer.find((EObject)object, (Collection)rootEObject.getCoreContent().getSpecifications())) {
            EObject eObject = ref.getEObject();
            if (!(eObject instanceof SpecHierarchy)) continue;
            return (SpecHierarchy)eObject;
        }
        return null;
    }

    public static Specification getSpecificationFromType(SpecType type) {
        ReqIF rootEObject = (ReqIF)EcoreUtil.getRootContainer((EObject)type);
        for (Specification spec : rootEObject.getCoreContent().getSpecifications()) {
            if (!type.equals(spec.getType())) continue;
            return spec;
        }
        return null;
    }
}

