/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.ju.testcases;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.helpers.IResourceHelpers;
import org.polarsys.capella.vp.requirements.ju.transposer.TestRequirementsImportLauncher;
import org.polarsys.capella.vp.requirements.ui.commands.ReqVPCustomDataHelper;
import org.polarsys.capella.vp.requirements.ui.commands.SaveQueriesCommand;

public class RequirementsCustomDataTestCase
extends BasicTestCase {
    private static final String systemAnalysis = "24658239-7734-4c39-9402-83325c52d04c";
    private static final String inputFileName = "model/inputs/model1.reqif";
    private static final String projectTestName = "emptymodel";

    public List<String> getRequiredTestModels() {
        return Arrays.asList(projectTestName);
    }

    public void test() throws Exception {
        SessionContext sessionContext = new SessionContext(this.getSession(projectTestName));
        final EObject target = sessionContext.getSemanticElement(systemAnalysis);
        if (target instanceof BlockArchitecture) {
            TransactionHelper.getExecutionManager((EObject)target).execute((ICommand)new AbstractReadWriteCommand(){

                public void run() {
                    File file = IResourceHelpers.getFileOrFolderInTestPlugin(((Object)((Object)this)).getClass(), (String)RequirementsCustomDataTestCase.inputFileName);
                    URI model = URI.createFileURI((String)file.getPath());
                    new TestRequirementsImportLauncher().launch(model, (BlockArchitecture)target, (IProgressMonitor)new NullProgressMonitor());
                }
            });
            RequirementsCustomDataTestCase.assertNull((Object)ReqVPCustomDataHelper.getCustomData((Session)sessionContext.getSession()));
            EAnnotation queriesAnnotation = ReqVPCustomDataHelper.getCustomData((Session)sessionContext.getSession());
            if (queriesAnnotation == null) {
                queriesAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            }
            TransactionalEditingDomain domain = sessionContext.getSession().getTransactionalEditingDomain();
            domain.getCommandStack().execute((Command)new SaveQueriesCommand(domain, sessionContext.getSession(), queriesAnnotation, "label1", "content1", "1", "1"));
            EAnnotation savedQueriesAnnotation = ReqVPCustomDataHelper.getCustomData((Session)sessionContext.getSession());
            RequirementsCustomDataTestCase.assertNotNull((Object)savedQueriesAnnotation);
            RequirementsCustomDataTestCase.assertEquals((String)((String)savedQueriesAnnotation.getDetails().get((Object)"REQUIREMENTS_VP_LABEL_QUERY")), (String)"label1");
            RequirementsCustomDataTestCase.assertEquals((String)((String)savedQueriesAnnotation.getDetails().get((Object)"REQUIREMENTS_VP_LABEL_LENGTH")), (String)"1");
            RequirementsCustomDataTestCase.assertEquals((String)((String)savedQueriesAnnotation.getDetails().get((Object)"REQUIREMENTS_VP_CONTENT_QUERY")), (String)"content1");
            RequirementsCustomDataTestCase.assertEquals((String)((String)savedQueriesAnnotation.getDetails().get((Object)"REQUIREMENTS_VP_CONTENT_LENGTH")), (String)"1");
            domain.getCommandStack().execute((Command)new SaveQueriesCommand(domain, sessionContext.getSession(), savedQueriesAnnotation, "label2", "content2", "2", "2"));
            EAnnotation savedQueriesAnnotation2 = ReqVPCustomDataHelper.getCustomData((Session)sessionContext.getSession());
            RequirementsCustomDataTestCase.assertNotNull((Object)savedQueriesAnnotation2);
            RequirementsCustomDataTestCase.assertEquals((String)((String)savedQueriesAnnotation2.getDetails().get((Object)"REQUIREMENTS_VP_LABEL_QUERY")), (String)"label2");
            RequirementsCustomDataTestCase.assertEquals((String)((String)savedQueriesAnnotation2.getDetails().get((Object)"REQUIREMENTS_VP_LABEL_LENGTH")), (String)"2");
            RequirementsCustomDataTestCase.assertEquals((String)((String)savedQueriesAnnotation2.getDetails().get((Object)"REQUIREMENTS_VP_CONTENT_QUERY")), (String)"content2");
            RequirementsCustomDataTestCase.assertEquals((String)((String)savedQueriesAnnotation2.getDetails().get((Object)"REQUIREMENTS_VP_CONTENT_LENGTH")), (String)"2");
        }
    }
}

