/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.importer.transposer.bridge;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.Display;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.commands.preferences.util.PreferencesHelper;
import org.polarsys.capella.vp.requirements.importer.transposer.bridge.ImageImportStrategy;
import org.polarsys.capella.vp.requirements.importer.transposer.bridge.ImageImporter;
import org.polarsys.capella.vp.requirements.importer.transposer.bridge.ImageImportingDialog;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;
import org.polarsys.kitalpha.vp.requirements.Requirements.AttributeOwner;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ReqIFTextParser {
    private ImageImporter imageImporter;
    private IContext context;
    private static final Logger LOGGER = ReportManagerRegistry.getInstance().subscribe("Default");

    public ReqIFTextParser(IContext context) {
        this.context = context;
        this.context.put((Object)"Images to copy", new HashMap());
    }

    public ReqIFTextParser(IContext context, ImageImporter imageImporter) {
        this(context);
        this.imageImporter = imageImporter;
    }

    public String transformToHTML(String content, AttributeOwner owner) {
        try {
            DocumentBuilderFactory df = DocumentBuilderFactory.newInstance();
            df.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            df.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            DocumentBuilder builder = df.newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(content)));
            this.transformToHTML(document, document.getDocumentElement());
            this.removeOLEObjects(document, document.getDocumentElement());
            this.replaceImgObjects(document, document.getDocumentElement());
            this.convertAllImgElements(document, document.getDocumentElement(), owner);
            StringWriter writer = new StringWriter();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(new DOMSource(document), new StreamResult(writer));
            return writer.toString();
        }
        catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
            LOGGER.log((Priority)Level.ERROR, (Object)"Error while parsing XHTML from ReqIF content", (Throwable)e);
            return content;
        }
    }

    protected void transformToHTML(Document document, Element element) {
        if (element.getTagName().equals("reqif:XHTML")) {
            document.renameNode(element, null, "p");
            while (element.getAttributes().getLength() > 0) {
                Node att = element.getAttributes().item(0);
                element.getAttributes().removeNamedItem(att.getNodeName());
            }
        } else {
            document.renameNode(element, null, element.getNodeName().replace("xhtml:", ""));
        }
        NodeList children = element.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child instanceof Element) {
                this.transformToHTML(document, (Element)child);
            }
            ++i;
        }
    }

    protected void removeOLEObjects(Document document, Element element) {
        NodeList children = element.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child instanceof Element) {
                if (this.isOLEObj((Element)child)) {
                    NodeList childrenOfOLEObj = child.getChildNodes();
                    int j = 0;
                    while (j < childrenOfOLEObj.getLength()) {
                        Node childOfOLEOjb = childrenOfOLEObj.item(j);
                        element.insertBefore(childOfOLEOjb, child);
                        ++j;
                    }
                    element.removeChild(child);
                } else {
                    this.removeOLEObjects(document, (Element)child);
                }
            }
            ++i;
        }
    }

    protected void replaceImgObjects(Document document, Element element) {
        NodeList children = element.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child instanceof Element) {
                if (this.isImgObj((Element)child)) {
                    Element imgElement = document.createElement("img");
                    imgElement.setAttribute("src", ((Element)child).getAttribute("data"));
                    element.insertBefore(imgElement, child);
                    element.removeChild(child);
                } else {
                    this.replaceImgObjects(document, (Element)child);
                }
            }
            ++i;
        }
    }

    protected void convertAllImgElements(Document document, Element element, AttributeOwner owner) {
        NodeList children = element.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child instanceof Element) {
                if (((Element)child).getTagName().equals("img")) {
                    this.convertImgElement(owner, child);
                } else {
                    this.convertAllImgElements(document, (Element)child, owner);
                }
            }
            ++i;
        }
    }

    protected void convertImgElement(AttributeOwner owner, Node child) {
        Element imgElement = (Element)child;
        if (this.imageImporter == null) {
            this.imageImporter = new ImageImporter();
            Display.getDefault().syncExec(() -> {
                ImageImportingDialog dialog = new ImageImportingDialog(Display.getDefault().getActiveShell(), this.imageImporter, this.getCurrentProject());
                dialog.open();
            });
        }
        if (this.imageImporter.getImgImportStrategy() != null) {
            this.convertImgElement(imgElement, owner);
        } else {
            LOGGER.log((Priority)Level.ERROR, (Object)"No valid image import strategy. Images won't be imported");
        }
    }

    protected void convertImgElement(Element imgElement, AttributeOwner owner) {
        String imgName = imgElement.getAttribute("src");
        if (this.imageImporter.getImgImportStrategy() == ImageImportStrategy.ABS_PATH) {
            imgElement.setAttribute("src", new File(this.imageImporter.getAbsPath(), imgName).toURI().toString());
            this.storeFileToCopy(imgName, this.getReqIFFolder(), this.imageImporter.getAbsPath(), owner);
        } else if (this.imageImporter.getImgImportStrategy() == ImageImportStrategy.REL_PATH) {
            imgElement.setAttribute("src", Paths.get(this.imageImporter.getRelPath(), imgName).toString());
            this.storeFileToCopy(imgName, this.getReqIFFolder(), new File(this.getCurrentProject().getLocation().toString(), this.imageImporter.getRelPath()).getPath(), owner);
        } else if (this.imageImporter.getImgImportStrategy() == ImageImportStrategy.EMBEDDED) {
            String base64Image = this.encode(new File(this.getReqIFFolder(), imgName).getPath());
            imgElement.setAttribute("src", base64Image);
        }
    }

    public String encode(String imagePath) {
        String base64Image = "";
        File file = new File(imagePath);
        String ext = FilenameUtils.getExtension((String)imagePath);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (FileInputStream fis = new FileInputStream(file);){
                byte[] imageData = new byte[(int)file.length()];
                int len = fis.read(imageData);
                while (len != -1) {
                    len = fis.read(imageData);
                }
                base64Image = "data:image/" + ext + ";base64," + Base64.getEncoder().encodeToString(imageData);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.log((Priority)Level.ERROR, (Object)"Error while encoding image to Base64", (Throwable)e);
        }
        return base64Image;
    }

    private String getReqIFFolder() {
        URI reqIFPath = (URI)this.context.get((Object)"CONTEXT_MODEL");
        return reqIFPath.trimSegments(1).toFileString();
    }

    public IProject getCurrentProject() {
        EObject targetElement = (EObject)this.context.get((Object)"TARGET_ELEMENT");
        return PreferencesHelper.getProject((EObject)targetElement);
    }

    private void storeFileToCopy(String fileName, String srcFolder, String targetFolder, AttributeOwner owner) {
        Path srcPath = Paths.get(new File(srcFolder, fileName).getPath(), new String[0]);
        Path targetPath = Paths.get(new File(targetFolder, fileName).getPath(), new String[0]);
        List<Path> srcPath2targetPath = Arrays.asList(srcPath, targetPath);
        Map reqID2Images = (Map)this.context.get((Object)"Images to copy");
        List images = reqID2Images.computeIfAbsent(owner.getReqIFIdentifier(), k -> new ArrayList());
        images.add(srcPath2targetPath);
    }

    private boolean isImgObj(Element element) {
        return element.getTagName().equals("object") && element.hasAttribute("type") && element.getAttribute("type").startsWith("image/");
    }

    private boolean isOLEObj(Element element) {
        return element.getTagName().equals("object") && element.hasAttribute("type") && element.getAttribute("type").equals("text/rtf") && element.hasAttribute("data") && element.getAttribute("data").endsWith(".ole");
    }
}

