/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.ui.commands;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.polarsys.capella.vp.requirements.ui.commands.Messages;

public class ReqVPConfigureDialog
extends TitleAreaDialog {
    private Text txtReqLabelExpression;
    private Text txtReqLabelMaxLength;
    private Text txtReqContentExpression;
    private Text txtReqContentMaxLength;
    private String labelExpression;
    private String labelMaxLength;
    private String contentExpression;
    private String contentMaxLength;

    public ReqVPConfigureDialog(Shell parentShell, String labelExpression, String contentExpression, String labelMaxLength, String contentMaxLength) {
        super(parentShell);
        this.labelExpression = labelExpression == null ? Messages.DefaultValueOfLabelExpression : labelExpression;
        this.contentExpression = contentExpression == null ? Messages.DefaultValueOfContentExpression : contentExpression;
        this.labelMaxLength = labelMaxLength == null ? Messages.DefaultValueOfLabelMaxLength : labelMaxLength;
        this.contentMaxLength = contentMaxLength == null ? Messages.DefaultValueOfContentMaxLength : contentMaxLength;
        this.setHelpAvailable(false);
        ReqVPConfigureDialog.setDialogHelpAvailable((boolean)false);
    }

    public void create() {
        super.create();
        this.setTitle(Messages.ReqVPConfigureDialog_Title);
        this.setMessage(Messages.ReqVPConfigureDialog_Message, 1);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        this.createAreaForLabelExpression(container);
        this.createAreaForContentExpression(container);
        return area;
    }

    private void createAreaForLabelExpression(Composite container) {
        Group group = this.createGroup(container, Messages.GROUP_TITLE_FOR_LABEL_AREA);
        this.createLabelInGroup(group, Messages.EXPRESSION_LABEL_TEXT);
        this.txtReqLabelExpression = this.createMultiLineTextInGroup(group, this.labelExpression);
        this.createLabelInGroup(group, Messages.LENGTH_LABEL_TEXT);
        this.txtReqLabelMaxLength = this.createSingleLineTextInGroup(group, this.labelMaxLength);
    }

    private void createAreaForContentExpression(Composite container) {
        Group group = this.createGroup(container, Messages.GROUP_TITLE_FOR_CONTENT_AREA);
        this.createLabelInGroup(group, Messages.EXPRESSION_LABEL_TEXT);
        this.txtReqContentExpression = this.createMultiLineTextInGroup(group, this.contentExpression);
        this.createLabelInGroup(group, Messages.LENGTH_LABEL_TEXT);
        this.txtReqContentMaxLength = this.createSingleLineTextInGroup(group, this.contentMaxLength);
    }

    private Text createMultiLineTextInGroup(Group group, String defaultText) {
        Text text = new Text((Composite)group, 2626);
        text.setText(defaultText);
        GridData txtExpressionGridData = new GridData(1808);
        txtExpressionGridData.grabExcessHorizontalSpace = true;
        txtExpressionGridData.horizontalAlignment = 4;
        txtExpressionGridData.heightHint = 5 * text.getLineHeight();
        txtExpressionGridData.widthHint = 400;
        text.setLayoutData((Object)txtExpressionGridData);
        return text;
    }

    private Text createSingleLineTextInGroup(Group group, String defaultText) {
        Text text = new Text((Composite)group, 2048);
        text.setText(defaultText);
        GridData txtMaxLengthGridData = new GridData();
        txtMaxLengthGridData.grabExcessHorizontalSpace = true;
        txtMaxLengthGridData.horizontalAlignment = 4;
        text.setLayoutData((Object)txtMaxLengthGridData);
        return text;
    }

    private Label createLabelInGroup(Group group, String labelText) {
        Label label = new Label((Composite)group, 0);
        label.setText(labelText);
        return label;
    }

    private Group createGroup(Composite container, String groupTitle) {
        Group group = new Group(container, 0);
        group.setText(groupTitle);
        GridData groupGridData = new GridData(4, 4, true, false);
        groupGridData.horizontalSpan = 2;
        group.setLayoutData((Object)groupGridData);
        group.setLayout((Layout)new GridLayout(2, false));
        return group;
    }

    protected boolean isResizable() {
        return true;
    }

    private void saveInput() {
        this.labelExpression = this.txtReqLabelExpression.getText();
        this.contentExpression = this.txtReqContentExpression.getText();
        try {
            this.labelMaxLength = String.valueOf(Integer.parseInt(this.txtReqLabelMaxLength.getText()));
        }
        catch (NumberFormatException e) {
            this.labelMaxLength = "";
        }
        try {
            this.contentMaxLength = String.valueOf(Integer.parseInt(this.txtReqContentMaxLength.getText()));
        }
        catch (NumberFormatException e) {
            this.contentMaxLength = "";
        }
    }

    protected void okPressed() {
        this.saveInput();
        super.okPressed();
    }

    public String getLabelExpression() {
        return this.labelExpression;
    }

    public String getContentExpression() {
        return this.contentExpression;
    }

    public String getLabelMaxLength() {
        return this.labelMaxLength;
    }

    public String getContentMaxLength() {
        return this.contentMaxLength;
    }
}

