/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.design.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.ContentLayerHelper;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.polarsys.capella.core.business.queries.IBusinessQuery;
import org.polarsys.capella.core.business.queries.capellacore.BusinessQueriesProvider;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.sirius.analysis.CapellaServices;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.vp.requirements.CapellaRequirements.CapellaIncomingRelation;
import org.polarsys.capella.vp.requirements.CapellaRequirements.CapellaOutgoingRelation;
import org.polarsys.capella.vp.requirements.CapellaRequirements.CapellaRequirementsFactory;
import org.polarsys.capella.vp.requirements.CapellaRequirements.CapellaRequirementsPackage;
import org.polarsys.capella.vp.requirements.ui.commands.ReqVPCustomDataHelper;
import org.polarsys.kitalpha.vp.requirements.Requirements.AbstractRelation;
import org.polarsys.kitalpha.vp.requirements.Requirements.InternalRelation;
import org.polarsys.kitalpha.vp.requirements.Requirements.RelationType;
import org.polarsys.kitalpha.vp.requirements.Requirements.Requirement;
import org.polarsys.kitalpha.vp.requirements.Requirements.RequirementsFactory;
import org.polarsys.kitalpha.vp.requirements.Requirements.RequirementsPackage;
import org.polarsys.kitalpha.vp.requirements.model.helpers.LabelHelper;

public class CapellaRequirementsOpenJavaService {
    public Collection<EObject> getAllAvailableRequirements(EObject context) {
        EObject element = context;
        if (element instanceof DSemanticDecorator) {
            element = ((DSemanticDecorator)element).getTarget();
        }
        ArrayList<EObject> result = new ArrayList<EObject>();
        IBusinessQuery incomingQuery = BusinessQueriesProvider.getInstance().getContribution(CapellacorePackage.Literals.CAPELLA_ELEMENT, (EStructuralFeature)CapellaRequirementsPackage.Literals.CAPELLA_INCOMING_RELATION__SOURCE);
        result.addAll(incomingQuery.getAvailableElements(element));
        IBusinessQuery outgoingQuery = BusinessQueriesProvider.getInstance().getContribution(CapellacorePackage.Literals.CAPELLA_ELEMENT, (EStructuralFeature)CapellaRequirementsPackage.Literals.CAPELLA_OUTGOING_RELATION__TARGET);
        result.addAll(outgoingQuery.getAvailableElements(element));
        return result;
    }

    public Collection<EObject> getVisibleRequirementsOnDiagram(EObject context) {
        DDiagram diagram = this.getDiagram(context);
        if (diagram != null) {
            return diagram.getDiagramElements().stream().map(DSemanticDecorator::getTarget).filter(Requirement.class::isInstance).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private DDiagram getDiagram(EObject context) {
        DDiagram result = null;
        if (context instanceof DDiagram) {
            result = (DDiagram)context;
        } else if (context instanceof DDiagramElement) {
            result = ((DDiagramElement)context).getParentDiagram();
        }
        return result;
    }

    public Collection<EObject> getAllRequirementsForElement(EObject elementView) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (elementView instanceof DSemanticDiagram) {
            DSemanticDiagram diagram = (DSemanticDiagram)elementView;
            result.addAll(this.getRequirementsForDiagram(diagram, true, true));
            for (DDiagramElement diagramElement : diagram.getDiagramElements()) {
                if (!(diagramElement.getTarget() instanceof CapellaElement)) continue;
                result.addAll(this.getRequirementsForDiagramElement(diagramElement, true, true));
            }
        } else if (elementView instanceof DDiagramElement) {
            result.addAll(this.getRequirementsForDiagramElement((DDiagramElement)elementView, true, true));
        }
        return result;
    }

    public Collection<EObject> getRequirementsForElement(EObject elementView, boolean incoming, boolean outgoing) {
        if (elementView instanceof DSemanticDiagram) {
            return this.getRequirementsForDiagram((DSemanticDiagram)elementView, incoming, outgoing);
        }
        if (elementView instanceof DDiagramElement) {
            return this.getRequirementsForDiagramElement((DDiagramElement)elementView, incoming, outgoing);
        }
        return Collections.emptyList();
    }

    private List<EObject> getRequirementsForDiagramElement(DDiagramElement diagramElement, boolean incoming, boolean outgoing) {
        EObject element = diagramElement.getTarget();
        if (element instanceof CapellaElement) {
            return this.getRequirementsForCapellaElement((CapellaElement)element, incoming, outgoing);
        }
        if (element instanceof Requirement) {
            return this.getRequirementsForRequirement((Requirement)element, incoming, outgoing);
        }
        return Collections.emptyList();
    }

    private List<EObject> getRequirementsForRequirement(Requirement requirement, boolean incoming, boolean outgoing) {
        IBusinessQuery query;
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (incoming) {
            query = BusinessQueriesProvider.getInstance().getContribution(RequirementsPackage.Literals.REQUIREMENT, (EStructuralFeature)RequirementsPackage.Literals.INTERNAL_RELATION__SOURCE);
            result.addAll(query.getCurrentElements((EObject)requirement, false));
        }
        if (outgoing) {
            query = BusinessQueriesProvider.getInstance().getContribution(RequirementsPackage.Literals.REQUIREMENT, (EStructuralFeature)RequirementsPackage.Literals.INTERNAL_RELATION__TARGET);
            result.addAll(query.getCurrentElements((EObject)requirement, false));
        }
        return result;
    }

    private List<EObject> getRequirementsForCapellaElement(CapellaElement element, boolean incoming, boolean outgoing) {
        IBusinessQuery query;
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (incoming) {
            query = BusinessQueriesProvider.getInstance().getContribution(CapellacorePackage.Literals.CAPELLA_ELEMENT, (EStructuralFeature)CapellaRequirementsPackage.Literals.CAPELLA_INCOMING_RELATION__SOURCE);
            result.addAll(query.getCurrentElements((EObject)element, false));
        }
        if (outgoing) {
            query = BusinessQueriesProvider.getInstance().getContribution(CapellacorePackage.Literals.CAPELLA_ELEMENT, (EStructuralFeature)CapellaRequirementsPackage.Literals.CAPELLA_OUTGOING_RELATION__TARGET);
            result.addAll(query.getCurrentElements((EObject)element, false));
        }
        return result;
    }

    private List<EObject> getRequirementsForDiagram(DSemanticDiagram diagram, boolean incoming, boolean outgoing) {
        IBusinessQuery query;
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (incoming) {
            query = BusinessQueriesProvider.getInstance().getContribution(ViewpointPackage.Literals.DREPRESENTATION_DESCRIPTOR, (EStructuralFeature)CapellaRequirementsPackage.Literals.CAPELLA_INCOMING_RELATION__SOURCE);
            result.addAll(query.getCurrentElements((EObject)RepresentationHelper.getRepresentationDescriptor((DRepresentation)diagram), false));
        }
        if (outgoing) {
            query = BusinessQueriesProvider.getInstance().getContribution(ViewpointPackage.Literals.DREPRESENTATION_DESCRIPTOR, (EStructuralFeature)CapellaRequirementsPackage.Literals.CAPELLA_OUTGOING_RELATION__TARGET);
            result.addAll(query.getCurrentElements((EObject)RepresentationHelper.getRepresentationDescriptor((DRepresentation)diagram), false));
        }
        return result;
    }

    public Collection<EObject> getExistingRequirementsInDiagram(EObject elementView, DDiagram diagram, boolean incoming, boolean outgoing) {
        Collection<EObject> requirements = this.getRequirementsForElement(elementView, incoming, outgoing);
        return diagram.getDiagramElements().stream().map(DSemanticDecorator::getTarget).filter(requirements::contains).collect(Collectors.toList());
    }

    public EObject hideRequirements(EObject diagram, Collection<EObject> selectedRequirements, Collection<EObject> requirementsInDiagram) {
        if (diagram instanceof DDiagram) {
            DDiagram ddiagram = (DDiagram)diagram;
            Set requirementsToHide = requirementsInDiagram.stream().filter(req -> !selectedRequirements.contains(req)).collect(Collectors.toSet());
            DiagramServices diagramService = DiagramServices.getDiagramServices();
            ddiagram.getDiagramElements().stream().filter(container -> requirementsToHide.contains(container.getTarget())).forEach(arg_0 -> ((DiagramServices)diagramService).removeContainerView(arg_0));
        }
        return diagram;
    }

    public String getRelationTypeLabel(AbstractRelation relation) {
        String name;
        RelationType type = relation.getRelationType();
        if (type != null && (name = type.getReqIFLongName()) != null) {
            return name;
        }
        return "";
    }

    public String getRequirementTitle(Requirement requirement) {
        Session session = SessionManager.INSTANCE.getSession((EObject)requirement);
        String expression = ReqVPCustomDataHelper.getDefaultLabelExpression();
        String maxLength = ReqVPCustomDataHelper.getDefaultLabelLength();
        EAnnotation queriesAnnotation = ReqVPCustomDataHelper.getCustomData((Session)session);
        if (queriesAnnotation != null) {
            expression = (String)queriesAnnotation.getDetails().get((Object)"REQUIREMENTS_VP_LABEL_QUERY");
            maxLength = (String)queriesAnnotation.getDetails().get((Object)"REQUIREMENTS_VP_LABEL_LENGTH");
        }
        return this.evaluateExpression(session, requirement, expression, maxLength);
    }

    public String getRequirementContent(Requirement requirement) {
        Session session = SessionManager.INSTANCE.getSession((EObject)requirement);
        String expression = ReqVPCustomDataHelper.getDefaultContentExpression();
        String maxLength = ReqVPCustomDataHelper.getDefaultContentLength();
        EAnnotation queriesAnnotation = ReqVPCustomDataHelper.getCustomData((Session)session);
        if (queriesAnnotation != null) {
            expression = (String)queriesAnnotation.getDetails().get((Object)"REQUIREMENTS_VP_CONTENT_QUERY");
            maxLength = (String)queriesAnnotation.getDetails().get((Object)"REQUIREMENTS_VP_CONTENT_LENGTH");
        }
        return this.evaluateExpression(session, requirement, expression, maxLength);
    }

    protected String evaluateExpression(Session session, Requirement requirement, String expression, String maxLength) {
        try {
            IInterpreter interpreter;
            if (session != null && expression != null && (interpreter = session.getInterpreter()) != null) {
                Object value = interpreter.evaluate((EObject)requirement, expression);
                StringBuilder resultBuilder = new StringBuilder();
                if (value instanceof List) {
                    for (Object item : (List)value) {
                        resultBuilder.append(item);
                    }
                } else {
                    resultBuilder.append(value);
                }
                String evaluationResult = resultBuilder.toString();
                String sanytizedResult = LabelHelper.transformHTMLToTextWithLineFeed((String)evaluationResult);
                return this.reduceString(sanytizedResult, maxLength);
            }
        }
        catch (EvaluationException ex) {
            return "<Undefined>";
        }
        return "<Undefined>";
    }

    protected String reduceString(String value, String maxLengthText) {
        if (maxLengthText.length() == 0) {
            return value;
        }
        int maxLen = Integer.parseInt(maxLengthText);
        if (maxLen == 0) {
            return value;
        }
        if (value.length() > maxLen) {
            return value.substring(0, maxLen).concat("...");
        }
        return value;
    }

    public Collection<EObject> findOutgoingRelationSource(CapellaOutgoingRelation relation) {
        return this.findRelationEnds(relation.getSource());
    }

    public Collection<EObject> findIncomingRelationTarget(CapellaIncomingRelation relation) {
        return this.findRelationEnds(relation.getTarget());
    }

    private List<EObject> findRelationEnds(CapellaElement element) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (element instanceof Component) {
            result.addAll(ComponentExt.getRepresentingParts((Component)((Component)element)));
        }
        result.add((EObject)element);
        return result;
    }

    public void createRequirementLink(EObject source, EObject target, EdgeTarget sourceView, EdgeTarget targetView) {
        if (source instanceof Requirement) {
            if (target instanceof CapellaElement) {
                CapellaIncomingRelation relation = this.createCapellaIncomingRelation((Requirement)source, (CapellaElement)target);
                this.createEdge("ReqVP_IncomingRelation", sourceView, targetView, (AbstractRelation)relation);
            } else if (target instanceof Requirement) {
                InternalRelation relation = this.createInternalRelation((Requirement)source, (Requirement)target);
                this.createEdge("ReqVP_InternalRelation", sourceView, targetView, (AbstractRelation)relation);
            }
        } else if (source instanceof CapellaElement && target instanceof Requirement) {
            CapellaOutgoingRelation relation = this.createCapellaOutgoingRelation((Requirement)target, (CapellaElement)source);
            this.createEdge("ReqVP_OutgoingRelation", sourceView, targetView, (AbstractRelation)relation);
        }
    }

    private DEdge createEdge(String mappingName, EdgeTarget sourceView, EdgeTarget targetView, AbstractRelation relation) {
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)sourceView);
        EdgeMapping mapping = this.getEdgeMapping(diagram, mappingName);
        return DiagramServices.getDiagramServices().createEdge(mapping, sourceView, targetView, (EObject)relation);
    }

    private EdgeMapping getEdgeMapping(DDiagram diagram, String mappingName) {
        for (Layer layer : diagram.getActivatedLayers()) {
            for (EdgeMapping mapping : ContentLayerHelper.getAllEdgeMappings((Layer)layer)) {
                if (!mapping.getName().equals(mappingName)) continue;
                return mapping;
            }
        }
        return null;
    }

    private CapellaOutgoingRelation createCapellaOutgoingRelation(Requirement requirement, CapellaElement capellaElement) {
        CapellaOutgoingRelation link = CapellaRequirementsFactory.eINSTANCE.createCapellaOutgoingRelation();
        if (capellaElement instanceof Part && ((Part)capellaElement).getAbstractType() instanceof CapellaElement) {
            CapellaElement type = (CapellaElement)((Part)capellaElement).getAbstractType();
            link.setSource(type);
            type.getOwnedExtensions().add((Object)link);
        } else {
            link.setSource(capellaElement);
            capellaElement.getOwnedExtensions().add((Object)link);
        }
        link.setTarget(requirement);
        link.setRelationType(this.getDefaultType((AbstractRelation)link));
        capellaElement.getOwnedExtensions().add((Object)link);
        return link;
    }

    private CapellaIncomingRelation createCapellaIncomingRelation(Requirement requirement, CapellaElement capellaElement) {
        CapellaIncomingRelation link = CapellaRequirementsFactory.eINSTANCE.createCapellaIncomingRelation();
        link.setSource(requirement);
        if (capellaElement instanceof Part && ((Part)capellaElement).getAbstractType() instanceof CapellaElement) {
            link.setTarget((CapellaElement)((Part)capellaElement).getAbstractType());
        } else {
            link.setTarget(capellaElement);
        }
        link.setRelationType(this.getDefaultType((AbstractRelation)link));
        requirement.getOwnedRelations().add((Object)link);
        return link;
    }

    private InternalRelation createInternalRelation(Requirement sourceRequirement, Requirement targetRequirment) {
        InternalRelation internalLink = RequirementsFactory.eINSTANCE.createInternalRelation();
        internalLink.setSource(sourceRequirement);
        internalLink.setTarget(targetRequirment);
        internalLink.setRelationType(this.getDefaultType((AbstractRelation)internalLink));
        sourceRequirement.getOwnedRelations().add((Object)internalLink);
        return internalLink;
    }

    private RelationType getDefaultType(AbstractRelation relation) {
        IBusinessQuery query = BusinessQueriesProvider.getInstance().getContribution(RequirementsPackage.eINSTANCE.getAbstractRelation(), (EStructuralFeature)RequirementsPackage.eINSTANCE.getAbstractRelation_RelationType());
        List availableElements = query.getAvailableElements((EObject)relation);
        if (availableElements.size() == 1) {
            return (RelationType)availableElements.get(0);
        }
        return null;
    }

    public boolean isLinkedToDiagram(EObject requirement, EObject diagram) {
        if (requirement instanceof Requirement && diagram instanceof DSemanticDiagram) {
            return this.getRequirementsForDiagram((DSemanticDiagram)diagram, true, true).stream().anyMatch(req -> req.equals(requirement));
        }
        return false;
    }
}

