/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.xhtml;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FrameType implements Enumerator
{
    VOID(0, "void", "void"),
    ABOVE(1, "above", "above"),
    BELOW(2, "below", "below"),
    HSIDES(3, "hsides", "hsides"),
    LHS(4, "lhs", "lhs"),
    RHS(5, "rhs", "rhs"),
    VSIDES(6, "vsides", "vsides"),
    BOX(7, "box", "box"),
    BORDER(8, "border", "border");

    public static final int VOID_VALUE = 0;
    public static final int ABOVE_VALUE = 1;
    public static final int BELOW_VALUE = 2;
    public static final int HSIDES_VALUE = 3;
    public static final int LHS_VALUE = 4;
    public static final int RHS_VALUE = 5;
    public static final int VSIDES_VALUE = 6;
    public static final int BOX_VALUE = 7;
    public static final int BORDER_VALUE = 8;
    private static final FrameType[] VALUES_ARRAY;
    public static final List<FrameType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new FrameType[]{VOID, ABOVE, BELOW, HSIDES, LHS, RHS, VSIDES, BOX, BORDER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static FrameType get(String literal) {
        FrameType[] frameTypeArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            FrameType result = frameTypeArray[n2];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static FrameType getByName(String name) {
        FrameType[] frameTypeArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            FrameType result = frameTypeArray[n2];
            if (result.getName().equals(name)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static FrameType get(int value) {
        switch (value) {
            case 0: {
                return VOID;
            }
            case 1: {
                return ABOVE;
            }
            case 2: {
                return BELOW;
            }
            case 3: {
                return HSIDES;
            }
            case 4: {
                return LHS;
            }
            case 5: {
                return RHS;
            }
            case 6: {
                return VSIDES;
            }
            case 7: {
                return BOX;
            }
            case 8: {
                return BORDER;
            }
        }
        return null;
    }

    private FrameType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

