/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.multiphases.activities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellacommon.CapellacommonFactory;
import org.polarsys.capella.core.data.capellacommon.JustificationLink;
import org.polarsys.capella.core.data.capellacore.Namespace;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.ctx.SystemFunction;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.LogicalFunction;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.data.pa.PhysicalComponent;

public class JustificationLinkPass {
    public void createJustificationLinks(EObject transformationTargetRoot_p, Collection<? extends PhysicalComponent> selectedNodePCs_p) {
        HashMap<String, PhysicalLink> sidToPhysicalLink = new HashMap<String, PhysicalLink>();
        HashMap<String, LogicalComponent> sidToLogicalComponent = new HashMap<String, LogicalComponent>();
        ArrayList<JustificationLink> newLinks = new ArrayList<JustificationLink>();
        TreeIterator it = transformationTargetRoot_p.eAllContents();
        while (it.hasNext()) {
            EObject next = (EObject)it.next();
            if (next instanceof ComponentExchange) {
                ComponentExchange ce = (ComponentExchange)next;
                newLinks.addAll(this.makeComponentExchangeToFunctionalExchangeJustificationLink(ce));
                continue;
            }
            if (next instanceof LogicalComponent) {
                LogicalComponent lc = (LogicalComponent)next;
                newLinks.addAll(this.makeLogicalComponentToSystemFunctionJustificationLinks(lc));
                if (lc.getSid() == null) continue;
                sidToLogicalComponent.put(lc.getSid(), lc);
                continue;
            }
            if (next instanceof PhysicalComponent) {
                newLinks.addAll(this.makePhysicalComponentToLogicalComponentJustificationLinks((PhysicalComponent)next, selectedNodePCs_p, sidToLogicalComponent));
                continue;
            }
            if (!(next instanceof PhysicalLink)) continue;
            PhysicalLink pl = (PhysicalLink)next;
            if (EcoreUtil2.getFirstContainer((EObject)next, (EClass)PaPackage.Literals.PHYSICAL_ARCHITECTURE) != null) {
                newLinks.addAll(this.makePhysicalLinkToComponentExchangeJustificationLinks(pl, (PhysicalLink)sidToPhysicalLink.get(pl.getSid())));
                continue;
            }
            sidToPhysicalLink.put(pl.getSid(), pl);
        }
        block1: for (JustificationLink l : newLinks) {
            TraceableElement e = l.getSource();
            while (e != null) {
                if (e instanceof Namespace) {
                    ((Namespace)e).getOwnedTraces().add((Object)l);
                    continue block1;
                }
                e = e.eContainer();
            }
        }
    }

    private Collection<JustificationLink> makePhysicalLinkToComponentExchangeJustificationLinks(PhysicalLink next_p, PhysicalLink collision_p) {
        ArrayList<JustificationLink> result = new ArrayList<JustificationLink>();
        if (collision_p != null) {
            for (ComponentExchange allocated : collision_p.getAllocatedComponentExchanges()) {
                JustificationLink jl = CapellacommonFactory.eINSTANCE.createJustificationLink();
                jl.setSourceElement((TraceableElement)next_p);
                jl.setTargetElement((TraceableElement)allocated);
                result.add(jl);
            }
        }
        return result;
    }

    private Collection<JustificationLink> makeLogicalComponentToSystemFunctionJustificationLinks(LogicalComponent logicalComponent_p) {
        ArrayList<JustificationLink> result = new ArrayList<JustificationLink>();
        for (AbstractFunction func : logicalComponent_p.getAllocatedFunctions()) {
            for (SystemFunction realizedSF : ((LogicalFunction)func).getRealizedSystemFunctions()) {
                JustificationLink jl = CapellacommonFactory.eINSTANCE.createJustificationLink();
                jl.setSourceElement((TraceableElement)logicalComponent_p);
                jl.setTargetElement((TraceableElement)realizedSF);
                result.add(jl);
            }
        }
        return result;
    }

    private Collection<JustificationLink> makeComponentExchangeToFunctionalExchangeJustificationLink(ComponentExchange componentExchange_p) {
        ArrayList<JustificationLink> result = new ArrayList<JustificationLink>();
        for (FunctionalExchange fe : componentExchange_p.getAllocatedFunctionalExchanges()) {
            for (FunctionalExchange realizedFE : fe.getRealizedFunctionalExchanges()) {
                JustificationLink jl = CapellacommonFactory.eINSTANCE.createJustificationLink();
                jl.setSourceElement((TraceableElement)componentExchange_p);
                jl.setTargetElement((TraceableElement)realizedFE);
                result.add(jl);
            }
        }
        return result;
    }

    private Collection<JustificationLink> makePhysicalComponentToLogicalComponentJustificationLinks(PhysicalComponent pc, Collection<? extends PhysicalComponent> selectedNodePCs_p, Map<String, LogicalComponent> sidToLogicalComponent_p) {
        ArrayList<JustificationLink> result = new ArrayList<JustificationLink>();
        if (pc.getSid() != null && !pc.getSid().isEmpty()) {
            for (PhysicalComponent referencePC : this.getReferenceScopeNodePCs(selectedNodePCs_p)) {
                if (!pc.getSid().equals(referencePC.getId())) continue;
                for (PhysicalComponent deployed : referencePC.getDeployedPhysicalComponents()) {
                    LogicalComponent lc = sidToLogicalComponent_p.get(deployed.getId());
                    if (lc == null) continue;
                    JustificationLink link = CapellacommonFactory.eINSTANCE.createJustificationLink();
                    link.setSourceElement((TraceableElement)pc);
                    link.setTargetElement((TraceableElement)lc);
                    result.add(link);
                }
            }
        }
        return result;
    }

    private Collection<PhysicalComponent> getReferenceScopeNodePCs(Collection<? extends PhysicalComponent> selectedPhysicalComponents_p) {
        ArrayList<PhysicalComponent> result = new ArrayList<PhysicalComponent>();
        TreeIterator it = EcoreUtil.getAllContents(selectedPhysicalComponents_p);
        while (it.hasNext()) {
            EObject next = (EObject)it.next();
            if (next instanceof PhysicalComponent) {
                result.add((PhysicalComponent)next);
                continue;
            }
            it.prune();
        }
        return result;
    }
}

