/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring2;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.resource.MoveResourceChange;
import org.eclipse.ltk.core.refactoring.resource.RenameResourceChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.ide.refactoring.RefactoringIssueAcceptor;
import org.eclipse.xtext.ide.serializer.IEmfResourceChange;
import org.eclipse.xtext.ide.serializer.ITextDocumentChange;
import org.eclipse.xtext.ui.refactoring.impl.EditorDocumentChange;
import org.eclipse.xtext.ui.refactoring2.ReplaceFileContentChange;
import org.eclipse.xtext.ui.refactoring2.ResourceURIConverter;
import org.eclipse.xtext.ui.refactoring2.TryWithResource;
import org.eclipse.xtext.ui.util.DisplayRunnableWithResult;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.internal.Nullable;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class ChangeConverter
implements IAcceptor<IEmfResourceChange> {
    private CompositeChange currentChange;
    private RefactoringIssueAcceptor issues;
    private Predicate<Change> changeFilter;
    @Extension
    private ResourceURIConverter resourceUriConverter;
    private IWorkbench workbench;

    protected ChangeConverter(String name, Predicate<Change> changeFilter, RefactoringIssueAcceptor issues, ResourceURIConverter uriConverter, IWorkbench workbench) {
        CompositeChange _compositeChange;
        this.currentChange = _compositeChange = new CompositeChange(name);
        this.issues = issues;
        this.changeFilter = changeFilter;
        this.resourceUriConverter = uriConverter;
        this.workbench = workbench;
    }

    public void accept(IEmfResourceChange emfResourceChange) {
        this.doConvert(emfResourceChange);
    }

    public Change getChange() {
        boolean _tripleEquals;
        int _length = this.currentChange.getChildren().length;
        boolean bl = _tripleEquals = _length == 0;
        if (_tripleEquals) {
            return null;
        }
        return this.currentChange;
    }

    protected void doConvert(IEmfResourceChange change) {
        this.handleReplacements(change);
        this.handleUriChange(change);
        boolean _affectsPersistedFiles = this.affectsPersistedFiles();
        if (_affectsPersistedFiles) {
            this.saveEditorsAfterApply();
        }
    }

    protected void _handleReplacements(IEmfResourceChange change) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Procedures.Procedure0 _function = () -> {
            try {
                boolean _not;
                IFile file = this.resourceUriConverter.toFile(change.getOldURI());
                boolean _canWrite = this.canWrite(file);
                boolean bl = _not = !_canWrite;
                if (_not) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Affected file '");
                    IPath _fullPath = file.getFullPath();
                    _builder.append((Object)_fullPath);
                    _builder.append("' is read-only");
                    this.issues.add(RefactoringIssueAcceptor.Severity.ERROR, _builder.toString(), new Object[0]);
                }
                this.checkDerived(file);
                change.getResource().save((OutputStream)outputStream, null);
                byte[] newContent = outputStream.toByteArray();
                String _lastSegment = change.getOldURI().lastSegment();
                ReplaceFileContentChange ltkChange = new ReplaceFileContentChange(_lastSegment, file, newContent);
                this.addChange((Change)ltkChange);
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        };
        TryWithResource.tryWith((Closeable)outputStream, _function);
    }

    protected void _handleReplacements(ITextDocumentChange change) {
        boolean _greaterThan;
        int _size = change.getReplacements().size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            boolean _not;
            IFile file = this.resourceUriConverter.toFile(change.getOldURI());
            boolean _canWrite = this.canWrite(file);
            boolean bl2 = _not = !_canWrite;
            if (_not) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Affected file '");
                IPath _fullPath = file.getFullPath();
                _builder.append((Object)_fullPath);
                _builder.append("' is read-only");
                this.issues.add(RefactoringIssueAcceptor.Severity.FATAL, _builder.toString(), new Object[0]);
            }
            this.checkDerived(file);
            Functions.Function1 _function = replacement -> {
                int _offset = replacement.getOffset();
                int _length = replacement.getLength();
                String _replacementText = replacement.getReplacementText();
                return new ReplaceEdit(_offset, _length, _replacementText);
            };
            List textEdits = ListExtensions.map((List)change.getReplacements(), (Functions.Function1)_function);
            MultiTextEdit textEdit = new MultiTextEdit();
            textEdit.addChildren((TextEdit[])Conversions.unwrapArray((Object)textEdits, TextEdit.class));
            ITextEditor openEditor = this.findOpenEditor(file);
            EditorDocumentChange _xifexpression = null;
            if (openEditor == null) {
                String _lastSegment = change.getOldURI().lastSegment();
                TextFileChange _textFileChange = new TextFileChange(_lastSegment, file);
                Procedures.Procedure1 _function_1 = it -> it.setSaveMode(2);
                _xifexpression = (TextChange)ObjectExtensions.operator_doubleArrow((Object)_textFileChange, (Procedures.Procedure1)_function_1);
            } else {
                String _name = this.currentChange.getName();
                _xifexpression = new EditorDocumentChange(_name, openEditor, false);
            }
            EditorDocumentChange ltkChange = _xifexpression;
            ltkChange.setEdit((TextEdit)textEdit);
            ltkChange.setTextType(change.getOldURI().fileExtension());
            this.addChange((Change)ltkChange);
        }
    }

    protected void handleUriChange(IEmfResourceChange change) {
        URI _oldURI;
        boolean _notEquals;
        URI _newURI = change.getNewURI();
        boolean bl = _notEquals = !Objects.equal((Object)_newURI, (Object)(_oldURI = change.getOldURI()));
        if (_notEquals) {
            String _lastSegment_1;
            String _lastSegment = change.getNewURI().lastSegment();
            boolean _equals = Objects.equal((Object)_lastSegment, (Object)(_lastSegment_1 = change.getOldURI().lastSegment()));
            if (_equals) {
                boolean _not;
                IFile oldFile = this.resourceUriConverter.toFile(change.getOldURI());
                boolean _canWrite = this.canWrite(oldFile);
                boolean bl2 = _not = !_canWrite;
                if (_not) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Cannot move read-only file '");
                    IPath _fullPath = oldFile.getFullPath();
                    _builder.append((Object)_fullPath);
                    _builder.append("'");
                    this.issues.add(RefactoringIssueAcceptor.Severity.FATAL, _builder.toString(), new Object[0]);
                }
                this.checkDerived(oldFile);
                IFile newFile = this.resourceUriConverter.toFile(change.getNewURI());
                IContainer newContainer = newFile.getParent();
                MoveResourceChange ltkChange = new MoveResourceChange((IResource)oldFile, newContainer);
                this.addChange((Change)ltkChange);
            } else {
                URI _trimSegments_1;
                URI _trimSegments = change.getNewURI().trimSegments(1);
                boolean _equals_1 = Objects.equal((Object)_trimSegments, (Object)(_trimSegments_1 = change.getOldURI().trimSegments(1)));
                if (_equals_1) {
                    IPath _fullPath_1 = this.resourceUriConverter.toFile(change.getOldURI()).getFullPath();
                    String _lastSegment_2 = change.getNewURI().lastSegment();
                    RenameResourceChange ltkChange_1 = new RenameResourceChange(_fullPath_1, _lastSegment_2);
                    this.addChange((Change)ltkChange_1);
                }
            }
        }
    }

    protected void addChange(Change change) {
        if (this.changeFilter == null || this.changeFilter.apply((Object)change)) {
            this.currentChange.add(change);
        }
    }

    protected boolean canWrite(IFile file) {
        return file.getWorkspace().validateEdit(new IFile[]{file}, IWorkspace.VALIDATE_PROMPT).isOK();
    }

    protected void checkDerived(IFile file) {
        boolean _isDerived = file.isDerived();
        if (_isDerived) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Affected file '");
            IPath _fullPath = file.getFullPath();
            _builder.append((Object)_fullPath);
            _builder.append("' is derived");
            this.issues.add(RefactoringIssueAcceptor.Severity.WARNING, _builder.toString(), new Object[0]);
        }
    }

    protected ITextEditor findOpenEditor(final IFile file) {
        ITextEditor _xblockexpression = null;
        if (this.workbench == null) {
            return null;
        }
        _xblockexpression = (ITextEditor)new DisplayRunnableWithResult<ITextEditor>(){

            @Override
            protected ITextEditor run() throws Exception {
                FileEditorInput editorInput = new FileEditorInput(file);
                Functions.Function1 _function = it -> it.getEditor(false);
                Functions.Function1 _function_1 = it -> {
                    IEditorInput _editorInput = it.getEditorInput();
                    return Objects.equal((Object)_editorInput, (Object)editorInput);
                };
                return (ITextEditor)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)ListExtensions.map((List)((List)Conversions.doWrapArray((Object)ChangeConverter.this.workbench.getActiveWorkbenchWindow().getActivePage().getEditorReferences())), (Functions.Function1)_function), ITextEditor.class), (Functions.Function1)_function_1);
            }
        }.syncExec();
        return _xblockexpression;
    }

    protected boolean affectsPersistedFiles() {
        Functions.Function1 _function = it -> !(it instanceof EditorDocumentChange);
        return IterableExtensions.exists((Iterable)((Iterable)Conversions.doWrapArray((Object)this.currentChange.getChildren())), (Functions.Function1)_function);
    }

    protected void saveEditorsAfterApply() {
        Iterable _filter = Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)this.currentChange.getChildren())), EditorDocumentChange.class);
        for (EditorDocumentChange change : _filter) {
            change.setDoSave(true);
        }
    }

    protected void handleReplacements(IEmfResourceChange change) {
        if (change instanceof ITextDocumentChange) {
            this._handleReplacements((ITextDocumentChange)change);
            return;
        }
        if (change != null) {
            this._handleReplacements(change);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(change).toString());
    }

    public static class Factory {
        @Inject
        private ResourceURIConverter resourceURIConverter;
        @Inject(optional=true)
        @Nullable
        private IWorkbench workbench;

        public ChangeConverter create(String name, Predicate<Change> changeFilter, RefactoringIssueAcceptor issues) {
            return new ChangeConverter(name, changeFilter, issues, this.resourceURIConverter, this.workbench);
        }
    }
}

