/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.ms.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.table.metamodel.table.DCell;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.statushandlers.StatusManager;
import org.polarsys.capella.common.linkedtext.ui.LinkedTextDocument;
import org.polarsys.capella.common.linkedtext.ui.LinkedTextHyperlink;
import org.polarsys.capella.core.data.capellacommon.StateMachine;
import org.polarsys.capella.core.linkedtext.ui.CapellaEmbeddedLinkedTextEditorInput;
import org.polarsys.capella.vp.ms.BooleanExpression;
import org.polarsys.capella.vp.ms.Situation;
import org.polarsys.capella.vp.ms.expression.parser.DefaultMsExpressionVisitor;
import org.polarsys.capella.vp.ms.expression.parser.LinkedText2Situation;
import org.polarsys.capella.vp.ms.expression.parser.MsExpressionUnparser;
import org.polarsys.capella.vp.ms.expression.parser.MsExpressionUtil;
import org.polarsys.capella.vp.ms.ui.SituationEditorDialog;

public class SituationExpressionHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = HandlerUtil.getCurrentStructuredSelection((ExecutionEvent)event);
        DCell cell = (DCell)selection.getFirstElement();
        final DColumn col = cell.getColumn();
        DLine row = cell.getLine();
        String inputText = "";
        if (col.getTarget() instanceof Situation && row.getTarget() instanceof StateMachine) {
            StateMachine rowSm = (StateMachine)row.getTarget();
            final LinkedText2Situation.SplitExpression splitExpression = LinkedText2Situation.SplitExpression.of((BooleanExpression)((Situation)col.getTarget()).getExpression());
            BooleanExpression rowExpression = (BooleanExpression)splitExpression.get((Object)rowSm);
            if (rowExpression != null) {
                inputText = new MsExpressionUnparser(MsExpressionUnparser.Mode.HYPERLINK).unparse(rowExpression);
            }
            final String text = inputText;
            final AtomicReference<String> toParse = new AtomicReference<String>(text);
            CapellaEmbeddedLinkedTextEditorInput input = new CapellaEmbeddedLinkedTextEditorInput(row.getTarget()){

                public String getText() {
                    return text;
                }

                public void setText(String linkedText) {
                    toParse.set(linkedText);
                }
            };
            SituationEditorDialog dialog = new SituationEditorDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), (LinkedTextDocument.Input)input);
            if (dialog.open() == 0) {
                block8: {
                    String expression = dialog.getDocument().get().trim();
                    if (expression.isEmpty()) {
                        splitExpression.remove((Object)rowSm);
                    } else {
                        try {
                            ArrayList<String> errors = new ArrayList<String>();
                            ParseTree tree = MsExpressionUtil.parse((String)toParse.get(), (ANTLRErrorListener)this.createErrorListener(errors));
                            if (errors.isEmpty()) {
                                splitExpression.put((Object)rowSm, (Object)((BooleanExpression)new DefaultMsExpressionVisitor(this.createResolver(dialog.getDocument())).visit(tree)));
                                break block8;
                            }
                            StatusManager.getManager().handle((IStatus)new Status(4, "org.polarsys.capella.vp.ms.ui", (String)errors.get(0)), 4);
                            return null;
                        }
                        catch (NoSuchElementException | RecognitionException e) {
                            StatusManager.getManager().handle((IStatus)new Status(4, "org.polarsys.capella.vp.ms.ui", e.getMessage(), e), 4);
                            return null;
                        }
                    }
                }
                TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)col.getTarget());
                RecordingCommand cmd = new RecordingCommand(domain){

                    protected void doExecute() {
                        ((Situation)col.getTarget()).setExpression((BooleanExpression)splitExpression.merge());
                    }
                };
                domain.getCommandStack().execute((Command)cmd);
            }
        }
        return null;
    }

    private ANTLRErrorListener createErrorListener(final Collection<String> errors) {
        return new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                errors.add("line " + line + ":" + charPositionInLine + " " + msg);
            }
        };
    }

    private Function<String, EObject> createResolver(final LinkedTextDocument document) {
        return new Function<String, EObject>(){

            @Override
            public EObject apply(String t) {
                for (LinkedTextHyperlink hl : document.getHyperlinks()) {
                    if (!t.equals(EcoreUtil.getID((EObject)((EObject)hl.getTarget())))) continue;
                    return (EObject)hl.getTarget();
                }
                throw new NoSuchElementException(t);
            }
        };
    }
}

