/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.ui.wizard;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.egf.common.EGFCommonPlugin;
import org.eclipse.egf.common.ui.wizard.AbstractExampleWizard;
import org.osgi.framework.Bundle;

public abstract class AllZipsBundleExampleWizard
extends AbstractExampleWizard {
    @Override
    protected void log(Exception e) {
        EGFCommonPlugin.getDefault().logError((Throwable)e);
    }

    @Override
    protected Collection<AbstractExampleWizard.ProjectDescriptor> getProjectDescriptors() {
        ArrayList<AbstractExampleWizard.ProjectDescriptor> projectDescriptors = new ArrayList<AbstractExampleWizard.ProjectDescriptor>();
        String bundleId = this.getBundleId();
        Bundle bundle = Platform.getBundle((String)bundleId);
        Enumeration urls = bundle.findEntries("zips", "*.zip", false);
        while (urls.hasMoreElements()) {
            Path urlPath = new Path(((URL)urls.nextElement()).toString());
            String zipPath = urlPath.removeFirstSegments(urlPath.segmentCount() - 2).setDevice(null).toPortableString();
            String projectName = urlPath.removeFileExtension().lastSegment();
            projectDescriptors.add(new AbstractExampleWizard.ProjectDescriptor(bundleId, zipPath, projectName));
        }
        return projectDescriptors;
    }

    protected abstract String getBundleId();
}

