/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.pattern.commands;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.common.helper.FileHelper;
import org.eclipse.egf.common.helper.ProjectHelper;
import org.eclipse.egf.common.helper.URIHelper;
import org.eclipse.egf.core.fcore.IPlatformFcore;
import org.eclipse.egf.core.fcore.IPlatformFcoreProvider;
import org.eclipse.egf.model.edit.EGFModelEditPlugin;
import org.eclipse.egf.model.edit.l10n.EGFModelEditMessages;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternLibrary;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.egf.model.pattern.PatternNameHelper;
import org.eclipse.egf.model.pattern.PatternPackage;
import org.eclipse.egf.model.pattern.commands.PatternLibraryRemovePatternCommand;
import org.eclipse.egf.model.pattern.template.TemplateModelFileHelper;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.osgi.util.NLS;

public class PatternLibraryAddPatternCommand
extends AddCommand {
    protected Collection<Pattern> _patterns;
    protected Map<PatternMethod, URI[]> _methods;
    protected Resource _resource;
    protected boolean _copy;

    private static IProject getProject(URIConverter converter, URI uri) {
        if (converter == null || uri == null) {
            return null;
        }
        if ((uri = converter.normalize(uri)) != null && uri.isPlatformResource()) {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(uri.segment(1));
        }
        return null;
    }

    public PatternLibraryAddPatternCommand(EditingDomain domain, PatternLibrary patternLibrary, Collection<?> collection, int index) {
        super(domain, (EObject)patternLibrary, (EStructuralFeature)PatternPackage.Literals.PATTERN_LIBRARY__ELEMENTS, collection, index);
    }

    protected boolean prepare() {
        boolean result = super.prepare();
        if (!result) {
            return false;
        }
        if (!(this.owner instanceof PatternLibrary)) {
            return false;
        }
        if (this.feature != PatternPackage.Literals.PATTERN_LIBRARY__ELEMENTS) {
            return false;
        }
        PatternLibrary library = (PatternLibrary)this.owner;
        Resource resource = library.eResource();
        if (resource == null || EMFHelper.getProject((Resource)resource) == null || !(resource instanceof IPlatformFcoreProvider)) {
            return false;
        }
        IPlatformFcore fcore = ((IPlatformFcoreProvider)resource).getIPlatformFcore();
        if (fcore == null) {
            return false;
        }
        this._patterns = new UniqueEList();
        this._methods = new HashMap<PatternMethod, URI[]>();
        for (Object object : this.collection) {
            if (!(object instanceof Pattern)) continue;
            Pattern pattern = (Pattern)object;
            this._patterns.add(pattern);
            try {
                for (PatternMethod method : pattern.getMethods()) {
                    URI[] uRIArray = new URI[2];
                    uRIArray[0] = method.getPatternFilePath();
                    this._methods.put(method, uRIArray);
                }
            }
            catch (Throwable t) {
                return false;
            }
        }
        this._resource = library.eResource();
        return true;
    }

    public void doExecute() {
        PatternLibrary library = (PatternLibrary)this.owner;
        IPlatformFcore fcore = ((IPlatformFcoreProvider)library.eResource()).getIPlatformFcore();
        List names = PatternNameHelper.getPatternNameWithinBundle((IPlatformFcore)fcore, (PatternLibrary)library, null);
        for (Pattern pattern : this._patterns) {
            PatternNameHelper.setUniquePatternName((IPlatformFcore)fcore, (Pattern)pattern, (List)names);
            names.add(pattern.getName());
        }
        super.doExecute();
        this._copy = PatternLibraryAddPatternCommand.performCreatePatternTemplates(this._resource, this._methods);
    }

    public void doUndo() {
        if (this._copy) {
            PatternLibraryRemovePatternCommand.performDeletePatterns(this._resource, this._patterns);
        }
        super.doUndo();
    }

    public void doRedo() {
        if (this._copy) {
            PatternLibraryRemovePatternCommand.performRestorePatterns(this._resource, this._patterns);
        }
        super.doRedo();
    }

    public static boolean performCreatePatternTemplates(Resource resource, final Map<PatternMethod, URI[]> methods) {
        if (resource == null || methods == null || methods.isEmpty() || !(resource instanceof IPlatformFcoreProvider)) {
            return false;
        }
        boolean copy = false;
        boolean restore = false;
        UniqueEList projects = new UniqueEList();
        final URIConverter converter = resource.getResourceSet().getURIConverter();
        for (Map.Entry<PatternMethod, URI[]> entry : methods.entrySet()) {
            IProject fromProject;
            URI toURI;
            PatternMethod method;
            URI fromURI = entry.getValue()[0];
            if (fromURI == null || (method = entry.getKey()).getPatternFilePath() == null || (toURI = TemplateModelFileHelper.computeFileURI((IPlatformFcore)((IPlatformFcoreProvider)resource).getIPlatformFcore(), (PatternMethod)method)) == null) continue;
            method.setPatternFilePath(toURI);
            entry.getValue()[1] = toURI;
            IProject toProject = PatternLibraryAddPatternCommand.getProject(converter, toURI);
            if (toProject == null) continue;
            if (fromURI.equals(toURI)) {
                IFile file = toProject.getFile(URIHelper.toPlatformProjectString((URI)fromURI, (boolean)true));
                if (!file.exists()) {
                    restore = true;
                }
            } else {
                copy = true;
            }
            if ((fromProject = PatternLibraryAddPatternCommand.getProject(converter, fromURI)) != null) {
                projects.add(fromProject);
            }
            projects.add(toProject);
        }
        WorkspaceJob job = new WorkspaceJob(EGFModelEditMessages.CopyPatternTemplateCommand_execute){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                try {
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(100 * methods.size()));
                    MultiStatus statii = new MultiStatus(EGFModelEditPlugin.getPlugin().getSymbolicName(), 4, EGFModelEditMessages.CopyPatternTemplatesCommand_execute_exception, null);
                    block5: for (Map.Entry entry : methods.entrySet()) {
                        URI fromURI = ((URI[])entry.getValue())[0];
                        if (fromURI == null) {
                            subMonitor.worked(100);
                            continue;
                        }
                        PatternMethod method = (PatternMethod)entry.getKey();
                        if (method.getPatternFilePath() == null) {
                            subMonitor.worked(100);
                            continue;
                        }
                        URI toURI = ((URI[])entry.getValue())[1];
                        IProject toProject = PatternLibraryAddPatternCommand.getProject(converter, toURI);
                        if (toProject == null) {
                            subMonitor.worked(100);
                            continue;
                        }
                        try {
                            if (fromURI.equals(toURI)) {
                                IFileState[] states;
                                IFile file = toProject.getFile(URIHelper.toPlatformProjectString((URI)fromURI, (boolean)true));
                                if (file.exists() || (states = file.getHistory(monitor)) == null || states.length <= 0) continue;
                                IFileState[] iFileStateArray = states;
                                int n = states.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IFileState state = iFileStateArray[n2];
                                    if (state.exists()) {
                                        FileHelper.createContainers((IProgressMonitor)subMonitor.newChild(50, 0), (IResource)file);
                                        file.create(state.getContents(), false, (IProgressMonitor)subMonitor.newChild(50, 0));
                                        continue block5;
                                    }
                                    ++n2;
                                }
                                continue;
                            }
                            InputStream input = null;
                            IProject fromProject = PatternLibraryAddPatternCommand.getProject(converter, fromURI);
                            if (fromProject != null) {
                                IFile fromFile = fromProject.getFile(URIHelper.toPlatformProjectString((URI)fromURI, (boolean)true));
                                if (!fromFile.exists()) {
                                    IFileState[] states = fromFile.getHistory(monitor);
                                    if (states != null && states.length > 0) {
                                        IFileState[] iFileStateArray = states;
                                        int n = states.length;
                                        int n3 = 0;
                                        while (n3 < n) {
                                            IFileState state = iFileStateArray[n3];
                                            if (state.exists()) {
                                                input = state.getContents();
                                                break;
                                            }
                                            ++n3;
                                        }
                                    }
                                } else {
                                    input = fromFile.getContents();
                                }
                            } else {
                                input = converter.createInputStream(fromURI);
                            }
                            if (input == null) {
                                throw new CoreException(EGFModelEditPlugin.getPlugin().newStatus(4, NLS.bind((String)EGFModelEditMessages.CopyPatternTemplateCommand_no_input_exception, (Object)fromURI), null));
                            }
                            IFile toFile = toProject.getFile(URIHelper.toPlatformProjectString((URI)toURI, (boolean)true));
                            FileHelper.createContainers((IProgressMonitor)subMonitor.newChild(50, 0), (IResource)toFile);
                            toFile.create(input, false, (IProgressMonitor)subMonitor.newChild(50, 0));
                        }
                        catch (Throwable t) {
                            if (t instanceof CoreException) {
                                statii.add(((CoreException)t).getStatus());
                                continue;
                            }
                            statii.add(EGFModelEditPlugin.getPlugin().newStatus(4, NLS.bind((String)EGFModelEditMessages.CopyPatternTemplateCommand_execute_exception, (Object)fromURI, (Object)toURI), t));
                        }
                    }
                    MultiStatus multiStatus = statii.getChildren().length != 0 ? statii : Status.OK_STATUS;
                    return multiStatus;
                }
                finally {
                    monitor.done();
                }
            }
        };
        if (copy || restore) {
            job.setRule(ProjectHelper.getRule((List)projects));
            job.schedule();
            return copy;
        }
        return false;
    }
}

