/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.util;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.sirius.business.api.session.resource.AirdResource;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.core.data.capellamodeller.util.CapellamodellerResourceImpl;
import org.polarsys.capella.docgen.Activator;
import org.polarsys.capella.docgen.util.CapellaServices;
import org.polarsys.capella.docgen.util.DocGenHtmlCapellaUtil;
import org.polarsys.capella.docgen.util.ImageHelper;
import org.polarsys.capella.shared.id.handler.IScope;
import org.polarsys.capella.shared.id.handler.IdManager;
import org.polarsys.kitalpha.doc.gen.business.core.util.DocGenHtmlUtil;

public class StringUtil {
    private static final String ELEMENT_LINK_REGEX = "hlink://(.+)";
    private static final String REGEX = "<[\\s]*[aA][\\s]+href[\\s]*=[\\s]*\"([^>]+)\"[\\s]*>(.*?)<[\\s]*/[\\s]*[aA][\\s]*>";
    private static final String REGEX_IMG = "<[\\s]*img[^>]*?src[\\s]*=[\\s]*\"([^>\"]+?)\"[^>]*?/[\\s]*>";
    private static final String REGEX_FilePATH = "<[aA][\\s]+href=\"(.+?)\">";
    private static final String ERROR_CPY = "Error during project relative image copy";

    public static String transformAREFString(EObject eObject, String input, String projectName, String outputFolder) {
        if (input != null) {
            input = StringUtil.manageModelAndDiagramElementsLinks(input, eObject);
            input = StringUtil.manageImages(eObject, input, projectName, outputFolder);
            input = StringUtil.manageFileLinks(eObject, input, projectName, outputFolder);
            return input;
        }
        return "";
    }

    private static String manageModelAndDiagramElementsLinks(String input, EObject eObject) {
        Pattern pattern = Pattern.compile(REGEX, 32);
        Matcher matcher = pattern.matcher(input);
        while (matcher.find()) {
            if (matcher.groupCount() != 2) continue;
            String akB = "<a href=\"";
            String akE = "</a>";
            String link = "<a href=\"" + StringUtil.switchToDocPath(matcher.group(1), eObject.eResource()) + "\">" + matcher.group(2) + "</a>";
            input = input.replace(matcher.group(0), link);
        }
        return input;
    }

    private static String manageFileLinks(EObject eObject, String input, String projectName, String outputFolder) {
        if (input.trim().length() == 0) {
            return input;
        }
        Pattern pattern = Pattern.compile(REGEX_FilePATH, 32);
        Matcher matcher = pattern.matcher(input);
        Path parentSrcFolder = new Path(eObject.eResource().getURI().segment(1));
        IPath parentTargetFolderPath = new Path(projectName).append(outputFolder);
        while (matcher.find()) {
            if (!matcher.group(1).startsWith("file://") && !matcher.group(1).startsWith("local://")) continue;
            String id = eObject.eGet(eObject.eClass().getEStructuralFeature("id")).toString();
            id = id.replace("-", "");
            Path patha = new Path(matcher.group(1).replaceAll("%20", " "));
            String iconName = String.valueOf(id) + "/" + patha.lastSegment();
            StringBuilder iconSourcePath = new StringBuilder();
            if (matcher.group(1).startsWith("file://")) {
                String[] stringArray = patha.segments();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String segment = stringArray[n2];
                    iconSourcePath.append("/").append(segment);
                    ++n2;
                }
            } else {
                IPath path = parentSrcFolder.append(matcher.group(1).substring(8, matcher.group(1).length()).replaceAll("%20", " "));
                IFile iconFile = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
                iconSourcePath.append(iconFile.getLocationURI().getPath());
            }
            IFolder parentTargetFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(parentTargetFolderPath);
            input = input.replace(matcher.group(1), "./files/" + iconName + "\"");
            ILog loger = Activator.getDefault().getLog();
            try {
                ImageHelper.INSTANCE.copyProjectImageToSystemLocation(iconSourcePath.toString(), String.valueOf(parentTargetFolder.getLocationURI().getPath()) + "/files/" + iconName);
            }
            catch (IOException e) {
                loger.log((IStatus)new Status(4, "org.polarsys.capella.docgen", ERROR_CPY, (Throwable)e));
            }
            catch (Exception e) {
                loger.log((IStatus)new Status(4, "org.polarsys.capella.docgen", ERROR_CPY, (Throwable)e));
            }
        }
        return input;
    }

    private static String manageImages(EObject eObject, String input, String projectName, String outputFolder) {
        if (input.trim().isEmpty()) {
            return input;
        }
        Pattern pattern = Pattern.compile(REGEX_IMG, 32);
        Matcher matcher = pattern.matcher(input);
        Path parentSrcFolder = new Path(eObject.eResource().getURI().segment(1));
        IPath parentTargetFolderPath = new Path(projectName).append(outputFolder);
        while (matcher.find()) {
            if (matcher.groupCount() != 1) continue;
            String id = eObject.eGet(eObject.eClass().getEStructuralFeature("id")).toString();
            id = id.replace("-", "");
            Path patha = new Path(matcher.group(1).replaceAll("%20", " "));
            String iconName = String.valueOf(id) + "/" + patha.lastSegment();
            String iconSourcePath = "";
            if (patha.isAbsolute()) {
                String[] stringArray = patha.segments();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String segment = stringArray[n2];
                    iconSourcePath = String.valueOf(iconSourcePath) + "/" + segment;
                    ++n2;
                }
            } else {
                IPath path = parentSrcFolder.append(matcher.group(1).replaceAll("%20", " "));
                IFile iconFile = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
                iconSourcePath = iconFile.getLocationURI().getPath();
            }
            IFolder parentTargetFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(parentTargetFolderPath);
            input = input.replace(matcher.group(1), "./images/" + iconName + "\"");
            ILog loger = Activator.getDefault().getLog();
            try {
                ImageHelper.INSTANCE.copyProjectImageToSystemLocation(iconSourcePath, String.valueOf(parentTargetFolder.getLocationURI().getPath()) + "/images/" + iconName);
            }
            catch (IOException e) {
                loger.log((IStatus)new Status(4, "org.polarsys.capella.docgen", ERROR_CPY, (Throwable)e));
            }
            catch (Exception e) {
                loger.log((IStatus)new Status(4, "org.polarsys.capella.docgen", ERROR_CPY, (Throwable)e));
            }
        }
        return input;
    }

    private static String switchToDocPath(String group, Resource resource) {
        Pattern pattern = Pattern.compile(ELEMENT_LINK_REGEX);
        Matcher matcher = pattern.matcher(group);
        StringBuffer buffer = new StringBuffer();
        if (matcher.find() && matcher.groupCount() == 1) {
            ResourceSet rs;
            EObject eObject;
            String id = matcher.group(1);
            if (id != null && id.trim().length() > 0 && id.contains("/")) {
                id = id.substring(0, id.length() - 1);
            }
            if ((eObject = resource.getEObject(id)) == null) {
                rs = resource.getResourceSet();
                for (Resource iResource : rs.getResources()) {
                    if (iResource instanceof CapellamodellerResourceImpl && (eObject = iResource.getEObject(id)) != null || iResource instanceof AirdResource && (eObject = iResource.getEObject(id)) != null) break;
                }
            }
            if (eObject == null) {
                rs = resource.getResourceSet();
                eObject = IdManager.getInstance().getEObject(id, new IScope(){

                    public List<Resource> getResources() {
                        return rs.getResources();
                    }
                });
            }
            if (eObject != null) {
                if (eObject instanceof DSemanticDiagram) {
                    buffer.append(CapellaServices.getPathFromElement(((DSemanticDiagram)eObject).getTarget()));
                    buffer.append("#");
                    buffer.append(CapellaServices.getDiagramUid((DSemanticDiagram)eObject));
                } else {
                    buffer.append(CapellaServices.getPathFromElement(eObject));
                }
                return buffer.toString();
            }
        }
        return group;
    }

    protected static String getPath(Resource resource, String id) {
        String newID = id.replaceAll("#", "");
        EObject eObject = resource.getEObject(newID);
        if (eObject != null) {
            String fileName = DocGenHtmlCapellaUtil.SERVICE.getFileName(eObject);
            String modelName = DocGenHtmlUtil.getModelName((EObject)eObject);
            String validFileName = "../" + modelName + "/" + DocGenHtmlUtil.getValidFileName((String)fileName) + "." + "html";
            return validFileName;
        }
        return "#";
    }

    public static String stringListToBulette(Collection<String> list_p) {
        StringBuffer buffer = new StringBuffer();
        if (list_p.size() < 1) {
            buffer.append("None");
        } else {
            buffer.append("<ul class=\"generatedList\">");
            for (String str : list_p) {
                StringUtil.buletteItem(buffer, str);
            }
            buffer.append("</ul>");
        }
        return buffer.toString();
    }

    public static String stringListToBulette(EList<? extends AbstractNamedElement> list_elts, String projectName, String outputFolder) {
        StringBuffer buffer = new StringBuffer();
        if (list_elts.size() < 1) {
            buffer.append("None");
        } else {
            buffer.append("<ul class=\"generatedList\">");
            for (AbstractNamedElement elt : list_elts) {
                buffer.append("<li>");
                buffer.append(CapellaServices.getImageLinkFromElement((EObject)elt, projectName, outputFolder));
                buffer.append(" ");
                buffer.append(CapellaServices.getHyperlinkFromElement((EObject)elt));
                buffer.append("</li>");
            }
            buffer.append("</ul>");
        }
        return buffer.toString();
    }

    private static void buletteItem(StringBuffer buffer, String str) {
        buffer.append("<li>");
        buffer.append(str);
        buffer.append("</li>");
    }

    public static String mapToHTMLTable(Map<String, String> map, String firstColTitle, String secondColTitle) {
        boolean generateTableHeader = firstColTitle != null && !firstColTitle.isEmpty() || secondColTitle != null && !secondColTitle.isEmpty();
        firstColTitle = firstColTitle == null ? "" : firstColTitle;
        secondColTitle = secondColTitle == null ? "" : secondColTitle;
        StringBuffer buffer = new StringBuffer();
        buffer.append("<table>");
        if (generateTableHeader) {
            buffer.append("<tr>").append("<th>");
            buffer.append(firstColTitle).append("</th>");
            buffer.append("<th>");
            buffer.append(secondColTitle);
            buffer.append("</th></tr>");
        }
        for (Map.Entry<String, String> e : map.entrySet()) {
            buffer.append("<tr>");
            buffer.append("<td>").append(e.getKey()).append("</td><td>").append(e.getValue()).append("</td>");
            buffer.append("</tr>");
        }
        buffer.append("</table>");
        return buffer.toString();
    }

    public static boolean containsNotEmptyString(Collection<String> stringSet) {
        for (String string : stringSet) {
            if (string == null || string.isEmpty()) continue;
            return true;
        }
        return false;
    }
}

