/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.configuration.ui.viewer;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.dialogs.PatternFilter;
import org.polarsys.capella.core.platform.sirius.ui.navigator.view.CapellaCommonNavigatorPatternFilter;
import org.polarsys.capella.docgen.configuration.ui.Activator;

public class CapellaNavigatorPatternFilter
extends CapellaCommonNavigatorPatternFilter {
    private static final String IMPOSSIBLE_TO_CLEAR_CACHE = "Impossible to clear cache";
    private static final String IMPOSSIBLE_TO_ACTIVATE_CACHE = "Impossible to activate cache";
    private String pattern;
    private Pattern matchingPattern;
    private boolean caseSensitiveEnabled = false;

    protected String getText(Viewer viewer, Object element) {
        return ((ILabelProvider)((StructuredViewer)viewer).getLabelProvider()).getText(element);
    }

    protected boolean isLeafMatch(Viewer viewer, Object element) {
        String labelText = this.getText(viewer, element);
        if (labelText == null) {
            return false;
        }
        return this.wordMatches(labelText);
    }

    public void setPattern(String patternString) {
        super.setPattern(patternString);
        if (patternString != null) {
            int flags = 0;
            if (!patternString.endsWith(" ")) {
                flags |= 0x20;
            }
            if (!this.caseSensitiveEnabled) {
                flags |= 2;
            }
            this.pattern = patternString;
            try {
                this.matchingPattern = Pattern.compile(this.pattern, flags);
            }
            catch (PatternSyntaxException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.capella.docgen.configuration.ui", e.getMessage()));
            }
        } else {
            this.pattern = "";
            this.matchingPattern = Pattern.compile(this.pattern);
        }
    }

    public String getPattern() {
        return this.pattern;
    }

    protected boolean wordMatches(String text) {
        if (this.pattern == null || this.pattern.isEmpty() || this.matchingPattern == null) {
            return true;
        }
        if (text == null) {
            return false;
        }
        return this.matchingPattern.matcher(text).find();
    }

    public void setCaseSensitiveEnabled(boolean caseSensitiveEnabled) {
        this.caseSensitiveEnabled = caseSensitiveEnabled;
    }

    public void doSetUseCache(boolean useCache) {
        try {
            Method setUseCacheMethod = PatternFilter.class.getDeclaredMethod("setUseCache", Boolean.TYPE);
            setUseCacheMethod.setAccessible(true);
            setUseCacheMethod.invoke((Object)this, useCache);
        }
        catch (IllegalAccessException e) {
            Activator.getDefault().getLog().error(IMPOSSIBLE_TO_ACTIVATE_CACHE, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            Activator.getDefault().getLog().error(IMPOSSIBLE_TO_ACTIVATE_CACHE, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Activator.getDefault().getLog().error(IMPOSSIBLE_TO_ACTIVATE_CACHE, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            Activator.getDefault().getLog().error(IMPOSSIBLE_TO_ACTIVATE_CACHE, (Throwable)e);
        }
        catch (SecurityException e) {
            Activator.getDefault().getLog().error(IMPOSSIBLE_TO_ACTIVATE_CACHE, (Throwable)e);
        }
    }

    public void doClearCaches() {
        try {
            Method clearCachesMethod = PatternFilter.class.getDeclaredMethod("clearCaches", new Class[0]);
            clearCachesMethod.setAccessible(true);
            clearCachesMethod.invoke((Object)this, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            Activator.getDefault().getLog().error(IMPOSSIBLE_TO_CLEAR_CACHE, (Throwable)e);
        }
        catch (SecurityException e) {
            Activator.getDefault().getLog().error(IMPOSSIBLE_TO_CLEAR_CACHE, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            Activator.getDefault().getLog().error(IMPOSSIBLE_TO_CLEAR_CACHE, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            Activator.getDefault().getLog().error(IMPOSSIBLE_TO_CLEAR_CACHE, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Activator.getDefault().getLog().error(IMPOSSIBLE_TO_CLEAR_CACHE, (Throwable)e);
        }
    }
}

