/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.xmlpivot.ui;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.ui.dialogs.DiagnosticDialog;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.model.handler.helpers.CapellaProjectHelper;
import org.polarsys.capella.core.model.skeleton.impl.cmd.CreateCapellaProjectCmd;
import org.polarsys.capella.core.platform.sirius.ui.project.operations.ProjectSessionCreationHelper;
import org.polarsys.capella.xmlpivot.ResourceLoader;
import org.polarsys.capella.xmlpivot.XMLPivotActivator;
import org.polarsys.capella.xmlpivot.XMLPivotResourceFactory;
import org.polarsys.capella.xmlpivot.importer.ImportAsNewProjectRunner;

public class PivotSessionCreationHelper
extends ProjectSessionCreationHelper {
    private ResourceLoader loader;
    private ImportAsNewProjectRunner runner = new ImportAsNewProjectRunner();
    private URI uri;
    private Shell shell = null;

    public PivotSessionCreationHelper(Shell shell_p, boolean epbsSelected_p, boolean opaSelected_p, CapellaProjectHelper.ProjectApproach projectApproach_p, URI uri_p) {
        super(epbsSelected_p, opaSelected_p, projectApproach_p);
        this.loader = new ResourceLoader();
        this.uri = uri_p;
        this.shell = shell_p;
    }

    public void fillNewModel(Project project, String name_p, IProgressMonitor monitor_p) {
    }

    protected ICommand createInitialElementsCommand(Resource resource_p, String projectName_p, IProgressMonitor monitor_p) {
        return new CreateCapellaProjectCmd(resource_p, projectName_p, this.getProjectApproach()){

            public void run() {
                super.run();
                this.getProject().eResource().getContents().addAll(PivotSessionCreationHelper.this.runner.getOtherHunks());
            }

            protected Project createProject(String name_p) {
                ResourceSetImpl set = new ResourceSetImpl();
                set.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xml", new XMLPivotResourceFactory());
                boolean dynamic = true;
                if (dynamic) {
                    set.setPackageRegistry(XMLPivotActivator.getDefault().getDynamicPackageRegistry());
                }
                Resource resource = PivotSessionCreationHelper.this.loader.load((ResourceSet)set, PivotSessionCreationHelper.this.uri);
                Diagnostic diagnostic = PivotSessionCreationHelper.this.loader.getDiagostic(resource);
                if (diagnostic.getSeverity() != 0) {
                    DiagnosticDialog.open((Shell)PivotSessionCreationHelper.this.shell, (String)"XML Pivot Import", (String)"Project will be created with partially loaded model", (Diagnostic)diagnostic);
                }
                try {
                    PivotSessionCreationHelper.this.runner.run((Collection)resource.getContents(), name_p, dynamic, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (WrappedException e) {
                    if (e instanceof Resource.Diagnostic) {
                        MessageDialog.openError((Shell)PivotSessionCreationHelper.this.shell, (String)"Error", (String)((Resource.Diagnostic)e).getMessage());
                        return null;
                    }
                    throw e;
                }
                return PivotSessionCreationHelper.this.runner.getProjectHunk();
            }
        };
    }

    private EObject createFragmentHolder(Collection<EObject> fragments) {
        EPackage pack = EcoreFactory.eINSTANCE.createEPackage();
        pack.setNsURI("http://xmlPivotImportHelper");
        EClass clazz = EcoreFactory.eINSTANCE.createEClass();
        pack.getEClassifiers().add((Object)clazz);
        clazz.setName("LostAndFound");
        EReference contents = EcoreFactory.eINSTANCE.createEReference();
        contents.setContainment(true);
        contents.setName("elements");
        contents.setUpperBound(-1);
        clazz.getEStructuralFeatures().add((Object)contents);
        contents.setEType((EClassifier)EcorePackage.Literals.EOBJECT);
        EObject holder = EcoreUtil.create((EClass)clazz);
        ((List)holder.eGet((EStructuralFeature)contents)).addAll(fragments);
        return holder;
    }
}

