/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.xmlpivot;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ResourceLoader {
    private final Map<Resource, Diagnostic> resourceToDiagnosticMap = new HashMap<Resource, Diagnostic>();

    public Diagnostic getDiagostic(Resource resource) {
        return this.resourceToDiagnosticMap.get(resource) == null ? Diagnostic.OK_INSTANCE : this.resourceToDiagnosticMap.get(resource);
    }

    public Resource load(ResourceSet set, URI uri) {
        Exception exception = null;
        Resource resource = null;
        try {
            resource = set.getResource(uri, true);
        }
        catch (RuntimeException e) {
            resource = set.getResource(uri, false);
        }
        Diagnostic diagnostic = this.analyzeResourceProblems(resource, exception);
        if (diagnostic.getSeverity() != 0) {
            this.resourceToDiagnosticMap.put(resource, diagnostic);
        }
        return resource;
    }

    private Diagnostic analyzeResourceProblems(Resource resource, Exception exception) {
        if (!resource.getErrors().isEmpty() || !resource.getWarnings().isEmpty()) {
            BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, "", 0, "Error while loading: " + resource.getURI(), new Object[]{exception == null ? resource : exception});
            basicDiagnostic.merge(EcoreUtil.computeDiagnostic((Resource)resource, (boolean)true));
            return basicDiagnostic;
        }
        if (exception != null) {
            return new BasicDiagnostic(4, "xmlpivotresourceloader", 0, "Error while loading: " + resource.getURI(), new Object[]{exception});
        }
        return Diagnostic.OK_INSTANCE;
    }
}

