/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.notification;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.capra.core.adapters.ArtifactMetaModelAdapter;
import org.eclipse.capra.core.adapters.Connection;
import org.eclipse.capra.core.adapters.TraceMetaModelAdapter;
import org.eclipse.capra.core.adapters.TracePersistenceAdapter;
import org.eclipse.capra.core.helpers.EditingDomainHelper;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.capra.core.helpers.TraceHelper;
import org.eclipse.capra.ui.notification.CapraNotificationHelper;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ui.IMarkerResolution;

public class RenameOrMoveQuickFix
implements IMarkerResolution {
    ArtifactMetaModelAdapter artifactAdapter = (ArtifactMetaModelAdapter)ExtensionPointHelper.getArtifactWrapperMetaModelAdapter().orElseThrow();
    private String label;

    RenameOrMoveQuickFix(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public void run(IMarker marker) {
        String oldArtifactUri;
        TracePersistenceAdapter tracePersistenceAdapter = (TracePersistenceAdapter)ExtensionPointHelper.getTracePersistenceAdapter().orElseThrow();
        ResourceSet resourceSet = EditingDomainHelper.getResourceSet();
        EObject traceModel = tracePersistenceAdapter.getTraceModel(resourceSet);
        EObject artifactModel = tracePersistenceAdapter.getArtifactWrappers(resourceSet);
        TraceMetaModelAdapter traceMetaModelAdapter = (TraceMetaModelAdapter)ExtensionPointHelper.getTraceMetamodelAdapter().orElseThrow();
        TraceHelper traceHelper = new TraceHelper(traceModel);
        String artifactContainerFileName = artifactModel.eResource().getURI().lastSegment();
        String markerFileName = new File(marker.getResource().toString()).getName();
        if (markerFileName.equals(artifactContainerFileName)) {
            List artifacts = this.artifactAdapter.getAllArtifacts(artifactModel);
            oldArtifactUri = marker.getAttribute("oldArtifactUri", null);
            for (EObject aw : artifacts) {
                if (!this.artifactAdapter.getArtifactUri(aw).equals(oldArtifactUri)) continue;
                String newArtifactUri = marker.getAttribute("newArtifactUri", null);
                this.artifactAdapter.createArtifact(artifactModel, this.artifactAdapter.getArtifactHandler(aw), newArtifactUri, marker.getAttribute("newArtifactName", null), newArtifactUri);
                break;
            }
        } else {
            List traces = traceMetaModelAdapter.getAllTraceLinks(traceModel);
            oldArtifactUri = marker.getAttribute("oldArtifactUri", null);
            URI markerUri = URI.createURI((String)oldArtifactUri);
            for (Connection c : traces) {
                for (EObject item : traceHelper.getTracedElements(c)) {
                    URI itemUri = CapraNotificationHelper.getFileUri(item);
                    if (!markerUri.equals(itemUri)) continue;
                    URI newUri = URI.createURI((String)marker.getAttribute("newArtifactUri", null));
                    ((InternalEObject)item).eSetProxyURI(newUri);
                }
            }
        }
        Resource resource = resourceSet.createResource(EcoreUtil.getURI((EObject)artifactModel));
        resource.getContents().add((Object)artifactModel);
        try {
            resource.save(null);
            marker.delete();
        }
        catch (IOException | CoreException e) {
            e.printStackTrace();
        }
    }
}

