/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.common.util;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Ints;
import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import org.eclipse.cbi.common.util.RecordDefinition;

class SeekableByteChannelRecordReader {
    private final SeekableByteChannel channel;

    public SeekableByteChannelRecordReader(SeekableByteChannel channel) {
        this.channel = channel;
    }

    public ByteBuffer read(RecordDefinition recordDefinition, long position) throws IOException {
        int recordLength = this.computeLength(recordDefinition, position);
        ByteBuffer buffer = ByteBuffer.allocate(recordLength);
        this.channel.position(position);
        int read = this.channel.read(buffer);
        if (read != buffer.capacity()) {
            throw new IOException("Did not read the correct number of byte (expected=" + buffer.capacity() + ", read=" + read + ")");
        }
        return (ByteBuffer)buffer.rewind();
    }

    private int uint16(RecordDefinition.Field field, RecordDefinition recordDefinition, long position) throws IOException {
        if (field.type() != RecordDefinition.Field.Type.UINT_16) {
            throw new IllegalArgumentException("Field is not uint16");
        }
        return this.readField(field, recordDefinition, position).getShort() & 0xFFFF;
    }

    public UnsignedInteger uint32(RecordDefinition.Field field, RecordDefinition recordDefinition, long position) throws IOException {
        if (field.type() != RecordDefinition.Field.Type.UINT_32) {
            throw new IllegalArgumentException("Field is not uint32");
        }
        return UnsignedInteger.fromIntBits(this.readField(field, recordDefinition, position).getInt());
    }

    private UnsignedLong uint64(RecordDefinition.Field field, RecordDefinition recordDefinition, long position) throws IOException {
        if (field.type() != RecordDefinition.Field.Type.UINT_64) {
            throw new IllegalArgumentException("Field is not uint64");
        }
        return UnsignedLong.fromLongBits(this.readField(field, recordDefinition, position).getLong());
    }

    private ByteBuffer readField(RecordDefinition.Field field, RecordDefinition recordDefinition, long position) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(field.type().size()).order(field.byteOrder());
        this.channel.position(this.position(field, recordDefinition, position));
        if (this.channel.read(buffer) != field.type().size()) {
            throw new IOException("Did not read the correct number of byte");
        }
        return (ByteBuffer)buffer.rewind();
    }

    private long position(RecordDefinition.Field field, RecordDefinition recordDefinition, long position) throws IOException {
        long value = position + this.offset(field, recordDefinition, position);
        if (value < 0L) {
            throw new ArithmeticException("long overflow");
        }
        return value;
    }

    private long offset(RecordDefinition.Field field, RecordDefinition recordDefinition, long position) throws IOException {
        long offset = 0L;
        for (RecordDefinition.Field f : recordDefinition.fields()) {
            if (field == f) break;
            if ((offset += this.size(f, recordDefinition, position)) >= 0L) continue;
            throw new ArithmeticException("long overflow");
        }
        return offset;
    }

    private long size(RecordDefinition.Field f, RecordDefinition recordDefinition, long position) throws IOException {
        long r;
        if (f.type() != RecordDefinition.Field.Type.VARIABLE) {
            r = f.type().size();
        } else {
            RecordDefinition.Field lenghtField = recordDefinition.fieldDefiningSizeOf(f);
            switch (lenghtField.type()) {
                case UINT_16: {
                    r = this.uint16(lenghtField, recordDefinition, position);
                    break;
                }
                case UINT_32: {
                    r = this.uint32(lenghtField, recordDefinition, position).longValue();
                    break;
                }
                case UINT_64: {
                    r = this.uint64(lenghtField, recordDefinition, position).longValue();
                    if (r >= 0L) break;
                    throw new ArithmeticException("Can not handle uint64 size larger than Long.MAX_VALUE");
                }
                default: {
                    throw new IllegalArgumentException("Unsupported FieldLength");
                }
            }
        }
        return r;
    }

    private int computeLength(RecordDefinition recordDefinition, long position) throws IOException {
        long r = 0L;
        for (RecordDefinition.Field f : recordDefinition.fields()) {
            if ((r += this.size(f, recordDefinition, position)) >= 0L) continue;
            throw new ArithmeticException("long overflow");
        }
        return Ints.checkedCast(r);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("channel", this.channel).toString();
    }
}

